/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.JmsTransactionTestSupport;
import org.apache.activemq.test.JmsResourceProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsQueueTransactionTest
extends JmsTransactionTestSupport {
    private static final Log log = LogFactory.getLog(JmsQueueTransactionTest.class);

    protected JmsResourceProvider getJmsResourceProvider() {
        JmsResourceProvider p = new JmsResourceProvider();
        p.setTopic(false);
        return p;
    }

    public void testReceiveTwoThenCloseConnection() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.session.commit();
        log.info("Sent 0: " + outbound[0]);
        log.info("Sent 1: " + outbound[1]);
        ArrayList<Message> messages = new ArrayList<Message>();
        Message message = this.consumer.receive(1000L);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(1000L);
        JmsQueueTransactionTest.assertNotNull((Object)message);
        this.assertEquals(outbound[1], message);
        this.reconnect();
        message = this.consumer.receive(5000L);
        JmsQueueTransactionTest.assertNotNull((String)"Should have re-received the first message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[0], message);
        message = this.consumer.receive(5000L);
        JmsQueueTransactionTest.assertNotNull((String)"Should have re-received the second message again!", (Object)message);
        messages.add(message);
        this.assertEquals(outbound[1], message);
        this.session.commit();
        Message[] inbound = new Message[messages.size()];
        messages.toArray(inbound);
        this.assertTextMessagesEqual("Rollback did not work", outbound, inbound);
    }

    public void testSendReceiveInSeperateSessionTest() throws Exception {
        this.session.close();
        int batchCount = 10;
        for (int i = 0; i < batchCount; ++i) {
            Session session = this.resourceProvider.createSession(this.connection);
            MessageProducer producer = this.resourceProvider.createProducer(session, this.destination);
            producer.send(session.createTextMessage("Test Message: " + i));
            session.commit();
            session.close();
            session = this.resourceProvider.createSession(this.connection);
            MessageConsumer consumer = this.resourceProvider.createConsumer(session, this.destination);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            JmsQueueTransactionTest.assertNotNull((String)("Received only " + i + " messages in batch "), (Object)message);
            JmsQueueTransactionTest.assertEquals((String)("Test Message: " + i), (String)message.getText());
            session.commit();
            session.close();
        }
    }

    public void testReceiveBrowseReceive() throws Exception {
        Message[] outbound = new Message[]{this.session.createTextMessage("First Message"), this.session.createTextMessage("Second Message"), this.session.createTextMessage("Third Message")};
        while (this.consumer.receive(1000L) != null) {
        }
        this.session.commit();
        this.producer.send(outbound[0]);
        this.producer.send(outbound[1]);
        this.producer.send(outbound[2]);
        this.session.commit();
        this.assertEquals(outbound[0], this.consumer.receive(1000L));
        this.consumer.close();
        QueueBrowser browser = this.session.createBrowser((Queue)this.destination);
        Enumeration enumeration = browser.getEnumeration();
        JmsQueueTransactionTest.assertTrue((String)"should have received the second message", (boolean)enumeration.hasMoreElements());
        this.assertEquals(outbound[1], (Message)enumeration.nextElement());
        JmsQueueTransactionTest.assertTrue((String)"Should have received the third message", (boolean)enumeration.hasMoreElements());
        this.assertEquals(outbound[2], (Message)enumeration.nextElement());
        boolean tooMany = false;
        while (enumeration.hasMoreElements()) {
            log.info("Got extra message: " + ((TextMessage)enumeration.nextElement()).getText());
            tooMany = true;
        }
        JmsQueueTransactionTest.assertFalse((boolean)tooMany);
        browser.close();
        this.consumer = this.resourceProvider.createConsumer(this.session, this.destination);
        this.assertEquals(outbound[1], this.consumer.receive(1000L));
        this.assertEquals(outbound[2], this.consumer.receive(1000L));
        this.consumer.close();
        this.session.commit();
    }
}

