/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsSendReceiveTestSupport
extends TestSupport
implements MessageListener {
    private static final Log log = LogFactory.getLog(JmsSendReceiveTestSupport.class);
    protected int messageCount = 100;
    protected String[] data;
    protected Session session;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected List messages = this.createConcurrentList();
    protected boolean topic = true;
    protected boolean durable = false;
    protected int deliveryMode = 2;
    protected final Object lock = new Object();
    protected boolean verbose = false;

    protected void setUp() throws Exception {
        int i;
        super.setUp();
        String temp = System.getProperty("messageCount");
        if (temp != null && (i = Integer.parseInt(temp)) > 0) {
            this.messageCount = i;
        }
        log.info("Message count for test case is: " + this.messageCount);
        this.data = new String[this.messageCount];
        for (i = 0; i < this.messageCount; ++i) {
            this.data[i] = "Text for message: " + i + " at " + new Date();
        }
    }

    public void testSendReceive() throws Exception {
        this.messages.clear();
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage message = this.session.createTextMessage(this.data[i]);
            message.setStringProperty("stringProperty", this.data[i]);
            message.setIntProperty("intProperty", i);
            if (this.verbose && log.isDebugEnabled()) {
                log.debug("About to send a message: " + message + " with text: " + this.data[i]);
            }
            this.producer.send(this.producerDestination, message);
            this.messageSent();
        }
        this.assertMessagesAreReceived();
        log.info("" + this.data.length + " messages(s) received, closing down connections");
    }

    protected void assertMessagesAreReceived() throws JMSException {
        this.waitForMessagesToBeDelivered();
        this.assertMessagesReceivedAreValid(this.messages);
    }

    protected void assertMessagesReceivedAreValid(List receivedMessages) throws JMSException {
        List<Object> copyOfMessages = Arrays.asList(receivedMessages.toArray());
        int counter = 0;
        if (this.data.length != copyOfMessages.size()) {
            Iterator<Object> iter = copyOfMessages.iterator();
            while (iter.hasNext()) {
                TextMessage message = (TextMessage)iter.next();
                if (!log.isDebugEnabled()) continue;
                log.info("<== " + counter++ + " = " + message);
            }
        }
        JmsSendReceiveTestSupport.assertEquals((String)"Not enough messages received", (int)this.data.length, (int)receivedMessages.size());
        for (int i = 0; i < this.data.length; ++i) {
            TextMessage received = (TextMessage)receivedMessages.get(i);
            String text = received.getText();
            String stringProperty = received.getStringProperty("stringProperty");
            int intProperty = received.getIntProperty("intProperty");
            if (this.verbose && log.isDebugEnabled()) {
                log.info("Received Text: " + text);
            }
            JmsSendReceiveTestSupport.assertEquals((String)("Message: " + i), (String)this.data[i], (String)text);
            JmsSendReceiveTestSupport.assertEquals((String)this.data[i], (String)stringProperty);
            JmsSendReceiveTestSupport.assertEquals((int)i, (int)intProperty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForMessagesToBeDelivered() {
        long maxWaitTime;
        long waitTime = maxWaitTime = 30000L;
        long start = maxWaitTime <= 0L ? 0L : System.currentTimeMillis();
        Object object = this.lock;
        synchronized (object) {
            while (this.messages.size() < this.data.length && waitTime >= 0L) {
                try {
                    this.lock.wait(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                waitTime = maxWaitTime - (System.currentTimeMillis() - start);
            }
        }
    }

    public synchronized void onMessage(Message message) {
        this.consumeMessage(message, this.messages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeMessage(Message message, List messageList) {
        if (this.verbose && log.isDebugEnabled()) {
            log.info("Received message: " + message);
        }
        messageList.add(message);
        if (messageList.size() >= this.data.length) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    protected List createConcurrentList() {
        return Collections.synchronizedList(new ArrayList());
    }

    protected void messageSent() throws Exception {
    }
}

