/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import org.apache.activemq.test.JmsTopicSendReceiveTest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicCompositeSendReceiveTest
extends JmsTopicSendReceiveTest {
    private static final Log log = LogFactory.getLog(JmsTopicCompositeSendReceiveTest.class);
    Destination consumerDestination2;
    MessageConsumer consumer2;

    protected void setUp() throws Exception {
        this.deliveryMode = 1;
        super.setUp();
        this.consumerDestination2 = this.consumeSession.createTopic("FOO.BAR.HUMBUG2");
        log.info("Created  consumer destination: " + this.consumerDestination2 + " of type: " + this.consumerDestination2.getClass());
        if (this.durable) {
            log.info("Creating durable consumer");
            this.consumer2 = this.consumeSession.createDurableSubscriber((Topic)this.consumerDestination2, this.getName());
        } else {
            this.consumer2 = this.consumeSession.createConsumer(this.consumerDestination2);
        }
    }

    protected String getConsumerSubject() {
        return "FOO.BAR.HUMBUG";
    }

    protected String getProducerSubject() {
        return "FOO.BAR.HUMBUG,FOO.BAR.HUMBUG2";
    }

    public void testSendReceive() throws Exception {
        super.testSendReceive();
        this.messages.clear();
        this.consumer2.setMessageListener(this);
        this.assertMessagesAreReceived();
        log.info("" + this.data.length + " messages(s) received, closing down connections");
    }
}

