/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.TestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicRedeliverTest
extends TestSupport {
    private static final Log log = LogFactory.getLog(JmsTopicRedeliverTest.class);
    protected Connection connection;
    protected Session session;
    protected Session consumeSession;
    protected MessageConsumer consumer;
    protected MessageProducer producer;
    protected Destination consumerDestination;
    protected Destination producerDestination;
    protected boolean topic = true;
    protected boolean durable = false;
    protected boolean verbose = false;
    protected long initRedeliveryDelay = 0L;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        this.initRedeliveryDelay = ((ActiveMQConnection)this.connection).getRedeliveryPolicy().getInitialRedeliveryDelay();
        if (this.durable) {
            this.connection.setClientID(((Object)((Object)this)).getClass().getName());
        }
        log.info("Created connection: " + this.connection);
        this.session = this.connection.createSession(false, 2);
        this.consumeSession = this.connection.createSession(false, 2);
        log.info("Created session: " + this.session);
        log.info("Created consumeSession: " + this.consumeSession);
        this.producer = this.session.createProducer(null);
        log.info("Created producer: " + this.producer);
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        log.info("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        log.info("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        this.consumer = this.createConsumer();
        this.connection.start();
        log.info("Created connection: " + this.connection);
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected String getConsumerSubject() {
        return "TEST";
    }

    protected String getProducerSubject() {
        return "TEST";
    }

    public void testRecover() throws Exception {
        String text = "TEST";
        TextMessage sendMessage = this.session.createTextMessage(text);
        if (this.verbose) {
            log.info("About to send a message: " + sendMessage + " with text: " + text);
        }
        this.producer.send(this.producerDestination, sendMessage);
        Message unackMessage = this.consumer.receive(this.initRedeliveryDelay + 1000L);
        JmsTopicRedeliverTest.assertNotNull((Object)unackMessage);
        String unackId = unackMessage.getJMSMessageID();
        JmsTopicRedeliverTest.assertEquals((String)((TextMessage)unackMessage).getText(), (String)text);
        JmsTopicRedeliverTest.assertFalse((boolean)unackMessage.getJMSRedelivered());
        this.consumeSession.recover();
        Message ackMessage = this.consumer.receive(this.initRedeliveryDelay + 1000L);
        JmsTopicRedeliverTest.assertNotNull((Object)ackMessage);
        ackMessage.acknowledge();
        String ackId = ackMessage.getJMSMessageID();
        JmsTopicRedeliverTest.assertEquals((String)((TextMessage)ackMessage).getText(), (String)text);
        JmsTopicRedeliverTest.assertTrue((boolean)ackMessage.getJMSRedelivered());
        JmsTopicRedeliverTest.assertEquals((String)unackId, (String)ackId);
        this.consumeSession.recover();
        JmsTopicRedeliverTest.assertNull((Object)this.consumer.receiveNoWait());
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            log.info("Creating durable consumer");
            return this.consumeSession.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.consumeSession.createConsumer(this.consumerDestination);
    }
}

