/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Topic;
import org.apache.activemq.JmsSendReceiveTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicSendReceiveTest
extends JmsSendReceiveTestSupport {
    private static final Log log = LogFactory.getLog(JmsTopicSendReceiveTest.class);
    protected Connection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        this.connection = this.createConnection();
        if (this.durable) {
            this.connection.setClientID(this.getClass().getName());
        }
        log.info("Created connection: " + this.connection);
        this.session = this.connection.createSession(false, 1);
        log.info("Created session: " + this.session);
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        log.info("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        log.info("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        log.info("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener(this);
        this.connection.start();
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (this.durable) {
            log.info("Creating durable consumer");
            return this.session.createDurableSubscriber((Topic)this.consumerDestination, this.getName());
        }
        return this.session.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        log.info("Dumping stats...");
        log.info("Closing down connection");
        this.session.close();
        this.connection.close();
    }
}

