/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.tcp.TcpTransport;

public class ProducerFlowControlTest
extends JmsTestSupport {
    ActiveMQQueue queueA = new ActiveMQQueue("QUEUE.A");
    ActiveMQQueue queueB = new ActiveMQQueue("QUEUE.B");
    private TransportConnector connector;
    private ActiveMQConnection connection;

    public void test2ndPubisherWithSyncSendConnectionThatIsBlocked() throws Exception {
        ActiveMQConnectionFactory factory = (ActiveMQConnectionFactory)this.createConnectionFactory();
        factory.setUseSyncSend(true);
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        this.fillQueue(this.queueA);
        Session session = this.connection.createSession(false, 2);
        MessageConsumer consumer = session.createConsumer(this.queueB);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        TextMessage msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 1", (String)msg.getText());
        msg.acknowledge();
        pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 2");
        ProducerFlowControlTest.assertTrue((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
        msg = (TextMessage)consumer.receive();
        ProducerFlowControlTest.assertEquals((String)"Message 2", (String)msg.getText());
        msg.acknowledge();
    }

    public void test2ndPubisherWithStandardConnectionThatIsBlocked() throws Exception {
        ConnectionFactory factory = this.createConnectionFactory();
        this.connection = (ActiveMQConnection)factory.createConnection();
        this.connections.add(this.connection);
        this.connection.start();
        this.fillQueue(this.queueA);
        CountDownLatch pubishDoneToQeueuB = this.asyncSendTo(this.queueB, "Message 1");
        ProducerFlowControlTest.assertFalse((boolean)pubishDoneToQeueuB.await(2L, TimeUnit.SECONDS));
    }

    private void fillQueue(final ActiveMQQueue queue) throws JMSException, InterruptedException {
        final AtomicBoolean done = new AtomicBoolean(true);
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        new Thread("Fill thread."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlTest.this.connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer(queue);
                    producer.setDeliveryMode(1);
                    while (keepGoing.get()) {
                        done.set(false);
                        producer.send(session.createTextMessage("Hello World"));
                    }
                }
                catch (JMSException jMSException) {
                    ProducerFlowControlTest.this.safeClose(session);
                    catch (Throwable throwable) {
                        ProducerFlowControlTest.this.safeClose(session);
                        throw throwable;
                    }
                }
                ProducerFlowControlTest.this.safeClose(session);
            }
        }.start();
        while (true) {
            Thread.sleep(1000L);
            if (done.get()) break;
            done.set(true);
        }
        keepGoing.set(false);
    }

    private CountDownLatch asyncSendTo(final ActiveMQQueue queue, final String message) throws JMSException {
        final CountDownLatch done = new CountDownLatch(1);
        new Thread("Send thread."){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                Session session = null;
                try {
                    session = ProducerFlowControlTest.this.connection.createSession(false, 1);
                    MessageProducer producer = session.createProducer(queue);
                    producer.setDeliveryMode(1);
                    producer.send(session.createTextMessage(message));
                    done.countDown();
                }
                catch (JMSException jMSException) {
                    ProducerFlowControlTest.this.safeClose(session);
                    catch (Throwable throwable) {
                        ProducerFlowControlTest.this.safeClose(session);
                        throw throwable;
                    }
                }
                ProducerFlowControlTest.this.safeClose(session);
            }
        }.start();
        return done;
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService service = new BrokerService();
        service.setPersistent(false);
        service.setUseJmx(true);
        PolicyMap policyMap = new PolicyMap();
        PolicyEntry policy = new PolicyEntry();
        policy.setMemoryLimit(1L);
        policyMap.setDefaultEntry(policy);
        service.setDestinationPolicy(policyMap);
        this.connector = service.addConnector("tcp://localhost:0");
        return service;
    }

    protected void tearDown() throws Exception {
        TcpTransport t = (TcpTransport)this.connection.getTransport().narrow(TcpTransport.class);
        t.getTransportListener().onException(new IOException("Disposed."));
        this.connection.getTransport().stop();
        super.tearDown();
    }

    protected ConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.connector.getConnectUri());
    }
}

