/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.LocalTransactionEventListener;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.DataArrayResponse;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.IntegerResponse;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.JMSExceptionSupport;
import org.apache.activemq.util.LongSequenceGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionContext
implements XAResource {
    private static final Log log = LogFactory.getLog(TransactionContext.class);
    private static final ConcurrentHashMap endedXATransactionContexts = new ConcurrentHashMap();
    private final ActiveMQConnection connection;
    private final LongSequenceGenerator localTransactionIdGenerator;
    private final ConnectionId connectionId;
    private ArrayList synchornizations;
    private Xid associatedXid;
    private TransactionId transactionId;
    private LocalTransactionEventListener localTransactionEventListener;

    public TransactionContext(ActiveMQConnection connection) {
        this.connection = connection;
        this.localTransactionIdGenerator = connection.getLocalTransactionIdGenerator();
        this.connectionId = connection.getConnectionInfo().getConnectionId();
    }

    public boolean isInXATransaction() {
        return this.transactionId != null && this.transactionId.isXATransaction();
    }

    public boolean isInLocalTransaction() {
        return this.transactionId != null && this.transactionId.isLocalTransaction();
    }

    public LocalTransactionEventListener getLocalTransactionEventListener() {
        return this.localTransactionEventListener;
    }

    public void setLocalTransactionEventListener(LocalTransactionEventListener localTransactionEventListener) {
        this.localTransactionEventListener = localTransactionEventListener;
    }

    public void addSynchronization(Synchronization s) {
        if (this.synchornizations == null) {
            this.synchornizations = new ArrayList(10);
        }
        this.synchornizations.add(s);
    }

    private void afterRollback() throws JMSException {
        if (this.synchornizations == null) {
            return;
        }
        int size = this.synchornizations.size();
        try {
            for (int i = 0; i < size; ++i) {
                ((Synchronization)this.synchornizations.get(i)).afterRollback();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    private void afterCommit() throws JMSException {
        if (this.synchornizations == null) {
            return;
        }
        int size = this.synchornizations.size();
        try {
            for (int i = 0; i < size; ++i) {
                ((Synchronization)this.synchornizations.get(i)).afterCommit();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    private void beforeEnd() throws JMSException {
        if (this.synchornizations == null) {
            return;
        }
        int size = this.synchornizations.size();
        try {
            for (int i = 0; i < size; ++i) {
                ((Synchronization)this.synchornizations.get(i)).beforeEnd();
            }
        }
        catch (JMSException e) {
            throw e;
        }
        catch (Throwable e) {
            throw JMSExceptionSupport.create(e);
        }
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void begin() throws JMSException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot start local transaction.  XA transaction is already in progress.");
        }
        if (this.transactionId == null) {
            this.synchornizations = null;
            this.transactionId = new LocalTransactionId(this.connectionId, this.localTransactionIdGenerator.getNextSequenceId());
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), this.transactionId, 0);
            this.connection.ensureConnectionInfoSent();
            this.connection.asyncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.beginEvent();
            }
        }
    }

    public void rollback() throws JMSException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot rollback() if an XA transaction is already in progress ");
        }
        if (this.transactionId != null) {
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), this.transactionId, 4);
            this.transactionId = null;
            this.connection.asyncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.rollbackEvent();
            }
        }
        this.afterRollback();
    }

    public void commit() throws JMSException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot commit() if an XA transaction is already in progress ");
        }
        this.beforeEnd();
        if (this.transactionId != null) {
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), this.transactionId, 2);
            this.transactionId = null;
            this.connection.syncSendPacket(info);
            if (this.localTransactionEventListener != null) {
                this.localTransactionEventListener.commitEvent();
            }
            this.afterCommit();
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("Start: " + xid);
        }
        if (this.isInLocalTransaction()) {
            throw new XAException(-6);
        }
        if (this.associatedXid != null) {
            throw new XAException(-6);
        }
        this.synchornizations = null;
        this.setXid(xid);
    }

    private ConnectionId getConnectionId() {
        return this.connection.getConnectionInfo().getConnectionId();
    }

    public void end(Xid xid, int flags) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("End: " + xid);
        }
        if (this.isInLocalTransaction()) {
            throw new XAException(-6);
        }
        if ((flags & 0x22000000) != 0) {
            if (!this.equals(this.associatedXid, xid)) {
                throw new XAException(-6);
            }
            try {
                this.beforeEnd();
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
            this.setXid(null);
        } else if ((flags & 0x4000000) == 0x4000000) {
            if (this.equals(this.associatedXid, xid)) {
                try {
                    this.beforeEnd();
                }
                catch (JMSException e) {
                    throw this.toXAException(e);
                }
                this.setXid(null);
            }
        } else {
            throw new XAException(-5);
        }
    }

    private boolean equals(Xid xid1, Xid xid2) {
        if (xid1 == xid2) {
            return true;
        }
        if (xid1 == null ^ xid2 == null) {
            return false;
        }
        return xid1.getFormatId() == xid2.getFormatId() && Arrays.equals(xid1.getBranchQualifier(), xid2.getBranchQualifier()) && Arrays.equals(xid1.getGlobalTransactionId(), xid2.getGlobalTransactionId());
    }

    public int prepare(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("Prepare: " + xid);
        }
        if (xid == null || this.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        XATransactionId x = new XATransactionId(xid);
        try {
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, 1);
            IntegerResponse response = (IntegerResponse)this.connection.syncSendPacket(info);
            return response.getResult();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("Rollback: " + xid);
        }
        if (xid == null) {
            throw new XAException(-6);
        }
        XATransactionId x = this.equals(this.associatedXid, xid) ? (XATransactionId)this.transactionId : new XATransactionId(xid);
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, 4);
            this.connection.syncSendPacket(info);
            ArrayList l = (ArrayList)endedXATransactionContexts.remove(x);
            if (l != null && !l.isEmpty()) {
                Iterator iter = l.iterator();
                while (iter.hasNext()) {
                    TransactionContext ctx = (TransactionContext)iter.next();
                    ctx.afterRollback();
                }
            }
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("Commit: " + xid);
        }
        if (xid == null || this.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        XATransactionId x = new XATransactionId(xid);
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
            TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, onePhase ? (byte)2 : 3);
            this.connection.syncSendPacket(info);
            ArrayList l = (ArrayList)endedXATransactionContexts.remove(x);
            if (l != null && !l.isEmpty()) {
                Iterator iter = l.iterator();
                while (iter.hasNext()) {
                    TransactionContext ctx = (TransactionContext)iter.next();
                    ctx.afterCommit();
                }
            }
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("Forget: " + xid);
        }
        if (xid == null) {
            throw new XAException(-6);
        }
        XATransactionId x = this.equals(this.associatedXid, xid) ? (XATransactionId)this.transactionId : new XATransactionId(xid);
        TransactionInfo info = new TransactionInfo(this.getConnectionId(), x, 6);
        try {
            this.connection.syncSendPacket(info);
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        if (!(xaResource instanceof TransactionContext)) {
            return false;
        }
        TransactionContext xar = (TransactionContext)xaResource;
        try {
            return this.getResourceManagerId().equals(xar.getResourceManagerId());
        }
        catch (Throwable e) {
            throw (XAException)new XAException("Could not get resource manager id.").initCause(e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        if (log.isDebugEnabled()) {
            log.debug("Recover: " + flag);
        }
        TransactionInfo info = new TransactionInfo(this.getConnectionId(), null, 5);
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
            DataArrayResponse receipt = (DataArrayResponse)this.connection.syncSendPacket(info);
            DataStructure[] data = receipt.getData();
            Xid[] answer = null;
            if (data instanceof XATransactionId[]) {
                answer = (XATransactionId[])data;
            } else {
                answer = new XATransactionId[data.length];
                System.arraycopy(data, 0, answer, 0, data.length);
            }
            return answer;
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        return false;
    }

    private String getResourceManagerId() throws JMSException {
        return this.connection.getResourceManagerId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setXid(Xid xid) throws XAException {
        try {
            this.connection.checkClosedOrFailed();
            this.connection.ensureConnectionInfoSent();
        }
        catch (JMSException e) {
            throw this.toXAException(e);
        }
        if (xid != null) {
            this.associatedXid = xid;
            this.transactionId = new XATransactionId(xid);
            TransactionInfo info = new TransactionInfo(this.connectionId, this.transactionId, 0);
            try {
                this.connection.asyncSendPacket(info);
                if (!log.isDebugEnabled()) return;
                log.debug("Started XA transaction: " + this.transactionId);
                return;
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
        }
        if (this.transactionId != null) {
            TransactionInfo info = new TransactionInfo(this.connectionId, this.transactionId, 7);
            try {
                this.connection.syncSendPacket(info);
                if (log.isDebugEnabled()) {
                    log.debug("Ended XA transaction: " + this.transactionId);
                }
            }
            catch (JMSException e) {
                throw this.toXAException(e);
            }
            ArrayList<TransactionContext> l = (ArrayList<TransactionContext>)endedXATransactionContexts.get(this.transactionId);
            if (l == null) {
                l = new ArrayList<TransactionContext>(3);
                endedXATransactionContexts.put(this.transactionId, l);
                l.add(this);
            } else if (!l.contains(this)) {
                l.add(this);
            }
        }
        this.associatedXid = null;
        this.transactionId = null;
    }

    private XAException toXAException(JMSException e) {
        if (e.getCause() != null && e.getCause() instanceof XAException) {
            XAException original = (XAException)e.getCause();
            XAException xae = new XAException(original.getMessage());
            xae.errorCode = original.errorCode;
            xae.initCause(original);
            return xae;
        }
        XAException xae = new XAException(e.getMessage());
        xae.errorCode = -7;
        xae.initCause(e);
        return xae;
    }

    public ActiveMQConnection getConnection() {
        return this.connection;
    }

    public void cleanup() {
        this.associatedXid = null;
        this.transactionId = null;
    }
}

