/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.spring.SpringConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZeroPrefetchConsumerTest
extends EmbeddedBrokerTestSupport {
    private static final Log log = LogFactory.getLog(ZeroPrefetchConsumerTest.class);
    protected Connection connection;
    protected Queue queue;

    public void testCannotUseMessageListener() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageConsumer consumer = session.createConsumer(this.queue);
        SpringConsumer listener = new SpringConsumer();
        try {
            consumer.setMessageListener(listener);
            ZeroPrefetchConsumerTest.fail((String)"Should have thrown JMSException as we cannot use MessageListener with zero prefetch");
        }
        catch (JMSException e) {
            log.info("Received expected exception : " + e);
        }
    }

    public void testPullConsumerWorks() throws Exception {
        Session session = this.connection.createSession(false, 1);
        MessageProducer producer = session.createProducer(this.queue);
        producer.send(session.createTextMessage("Hello World!"));
        MessageConsumer consumer = session.createConsumer(this.queue);
        Message answer = consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertNotNull((String)"Should have received a message!", (Object)answer);
        answer = consumer.receive(1L);
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
        answer = consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testIdleConsumer() throws Exception {
        this.doTestIdleConsumer(false);
    }

    public void testIdleConsumerTranscated() throws Exception {
        this.doTestIdleConsumer(true);
    }

    private void doTestIdleConsumer(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer(this.queue);
        producer.send(session.createTextMessage("Msg1"));
        producer.send(session.createTextMessage("Msg2"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer(this.queue);
        MessageConsumer idleConsumer = session.createConsumer(this.queue);
        TextMessage answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receive(5000L);
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    public void testRecvRecvCommit() throws Exception {
        this.doTestRecvRecvCommit(false);
    }

    public void testRecvRecvCommitTranscated() throws Exception {
        this.doTestRecvRecvCommit(true);
    }

    private void doTestRecvRecvCommit(boolean transacted) throws Exception {
        Session session = this.connection.createSession(transacted, 1);
        MessageProducer producer = session.createProducer(this.queue);
        producer.send(session.createTextMessage("Msg1"));
        producer.send(session.createTextMessage("Msg2"));
        if (transacted) {
            session.commit();
        }
        MessageConsumer consumer = session.createConsumer(this.queue);
        TextMessage answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg1");
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertEquals((String)"Should have received a message!", (String)answer.getText(), (String)"Msg2");
        if (transacted) {
            session.commit();
        }
        answer = (TextMessage)consumer.receiveNoWait();
        ZeroPrefetchConsumerTest.assertNull((String)"Should have not received a message!", (Object)answer);
    }

    protected void setUp() throws Exception {
        this.bindAddress = "tcp://localhost:61616";
        super.setUp();
        this.connection = this.createConnection();
        this.connection.start();
        this.queue = this.createQueue();
    }

    protected void tearDown() throws Exception {
        this.connection.close();
        super.tearDown();
    }

    protected Queue createQueue() {
        return new ActiveMQQueue(this.getDestinationString() + "?consumer.prefetchSize=0");
    }
}

