/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.Connection;
import org.apache.activemq.broker.Connector;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportStatusDetector;
import org.apache.activemq.broker.jmx.ManagedTransportConnector;
import org.apache.activemq.broker.region.ConnectorStatistics;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.security.MessageAuthorizationPolicy;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportAcceptListener;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransportConnector
implements Connector {
    private static final Log log = LogFactory.getLog(TransportConnector.class);
    private Broker broker;
    private TransportServer server;
    private URI uri;
    private BrokerInfo brokerInfo = new BrokerInfo();
    private TaskRunnerFactory taskRunnerFactory = null;
    private MessageAuthorizationPolicy messageAuthorizationPolicy;
    private DiscoveryAgent discoveryAgent;
    protected CopyOnWriteArrayList connections = new CopyOnWriteArrayList();
    protected TransportStatusDetector statusDector;
    private ConnectorStatistics statistics = new ConnectorStatistics();
    private URI discoveryUri;
    private URI connectUri;
    private String name;
    private boolean disableAsyncDispatch = false;
    private boolean enableStatusMonitor = true;

    public CopyOnWriteArrayList getConnections() {
        return this.connections;
    }

    public TransportConnector() {
    }

    public TransportConnector(Broker broker, TransportServer server) {
        this();
        URI uri;
        this.setBroker(broker);
        this.setServer(server);
        if (server != null && server.getConnectURI() != null && (uri = server.getConnectURI()) != null && uri.getScheme().equals("vm")) {
            this.setEnableStatusMonitor(false);
        }
    }

    public ManagedTransportConnector asManagedConnector(MBeanServer mbeanServer, ObjectName connectorName) throws IOException, URISyntaxException {
        ManagedTransportConnector rc = new ManagedTransportConnector(mbeanServer, connectorName, this.getBroker(), this.getServer());
        rc.setTaskRunnerFactory(this.getTaskRunnerFactory());
        rc.setUri(this.uri);
        rc.setConnectUri(this.connectUri);
        rc.setDiscoveryAgent(this.discoveryAgent);
        rc.setDiscoveryUri(this.discoveryUri);
        rc.setName(this.name);
        rc.setDisableAsyncDispatch(this.disableAsyncDispatch);
        rc.setBrokerInfo(this.brokerInfo);
        return rc;
    }

    public BrokerInfo getBrokerInfo() {
        return this.brokerInfo;
    }

    public void setBrokerInfo(BrokerInfo brokerInfo) {
        this.brokerInfo = brokerInfo;
    }

    public TransportServer getServer() throws IOException, URISyntaxException {
        if (this.server == null) {
            this.setServer(this.createTransportServer());
        }
        return this.server;
    }

    public Broker getBroker() {
        return this.broker;
    }

    public void setBroker(Broker broker) {
        this.broker = broker;
        this.brokerInfo.setBrokerId(broker.getBrokerId());
        this.brokerInfo.setPeerBrokerInfos(broker.getPeerBrokerInfos());
    }

    public void setBrokerName(String brokerName) {
        this.brokerInfo.setBrokerName(brokerName);
    }

    public void setServer(TransportServer server) {
        this.server = server;
        this.brokerInfo.setBrokerURL(server.getConnectURI().toString());
        this.server.setAcceptListener(new TransportAcceptListener(){

            public void onAccept(Transport transport) {
                try {
                    Connection connection = TransportConnector.this.createConnection(transport);
                    connection.start();
                }
                catch (Exception e) {
                    String remoteHost = transport.getRemoteAddress();
                    ServiceSupport.dispose(transport);
                    this.onAcceptError(e, remoteHost);
                }
            }

            public void onAcceptError(Exception error) {
                this.onAcceptError(error, null);
            }

            private void onAcceptError(Exception error, String remoteHost) {
                log.error("Could not accept connection " + (remoteHost == null ? "" : "from " + remoteHost) + ": " + error, error);
            }
        });
        this.server.setBrokerInfo(this.brokerInfo);
    }

    public URI getUri() {
        if (this.uri == null) {
            try {
                this.uri = this.getConnectUri();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public TaskRunnerFactory getTaskRunnerFactory() {
        return this.taskRunnerFactory;
    }

    public void setTaskRunnerFactory(TaskRunnerFactory taskRunnerFactory) {
        this.taskRunnerFactory = taskRunnerFactory;
    }

    public ConnectorStatistics getStatistics() {
        return this.statistics;
    }

    public MessageAuthorizationPolicy getMessageAuthorizationPolicy() {
        return this.messageAuthorizationPolicy;
    }

    public void setMessageAuthorizationPolicy(MessageAuthorizationPolicy messageAuthorizationPolicy) {
        this.messageAuthorizationPolicy = messageAuthorizationPolicy;
    }

    public void start() throws Exception {
        this.getServer().start();
        DiscoveryAgent da = this.getDiscoveryAgent();
        if (da != null) {
            da.setBrokerName(this.getBrokerInfo().getBrokerName());
            da.registerService(this.getConnectUri().toString());
            da.start();
        }
        if (this.enableStatusMonitor) {
            this.statusDector = new TransportStatusDetector(this);
            this.statusDector.start();
        }
        log.info("Connector " + this.getName() + " Started");
    }

    public void stop() throws Exception {
        ServiceStopper ss = new ServiceStopper();
        if (this.discoveryAgent != null) {
            ss.stop(this.discoveryAgent);
        }
        if (this.server != null) {
            ss.stop(this.server);
        }
        if (this.statusDector != null) {
            this.statusDector.stop();
        }
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            TransportConnection c = (TransportConnection)iter.next();
            ss.stop(c);
        }
        ss.throwFirstException();
        log.info("Connector " + this.getName() + " Stopped");
    }

    protected Connection createConnection(Transport transport) throws IOException {
        TransportConnection answer = new TransportConnection(this, transport, this.broker, this.disableAsyncDispatch ? null : this.taskRunnerFactory);
        answer.setMessageAuthorizationPolicy(this.messageAuthorizationPolicy);
        return answer;
    }

    protected TransportServer createTransportServer() throws IOException, URISyntaxException {
        if (this.uri == null) {
            throw new IllegalArgumentException("You must specify either a server or uri property");
        }
        if (this.broker == null) {
            throw new IllegalArgumentException("You must specify the broker property. Maybe this connector should be added to a broker?");
        }
        return TransportFactory.bind(this.broker.getBrokerId().getValue(), this.uri);
    }

    public DiscoveryAgent getDiscoveryAgent() throws IOException {
        if (this.discoveryAgent == null) {
            this.discoveryAgent = this.createDiscoveryAgent();
        }
        return this.discoveryAgent;
    }

    protected DiscoveryAgent createDiscoveryAgent() throws IOException {
        if (this.discoveryUri != null) {
            return DiscoveryAgentFactory.createDiscoveryAgent(this.discoveryUri);
        }
        return null;
    }

    public void setDiscoveryAgent(DiscoveryAgent discoveryAgent) {
        this.discoveryAgent = discoveryAgent;
    }

    public URI getDiscoveryUri() {
        return this.discoveryUri;
    }

    public void setDiscoveryUri(URI discoveryUri) {
        this.discoveryUri = discoveryUri;
    }

    public URI getConnectUri() throws IOException, URISyntaxException {
        if (this.connectUri == null && this.server != null) {
            this.connectUri = this.server.getConnectURI();
        }
        return this.connectUri;
    }

    public void setConnectUri(URI transportUri) {
        this.connectUri = transportUri;
    }

    public void onStarted(TransportConnection connection) {
        this.connections.add(connection);
    }

    public void onStopped(TransportConnection connection) {
        this.connections.remove(connection);
    }

    public String getName() {
        if (this.name == null) {
            this.uri = this.getUri();
            if (this.uri != null) {
                this.name = this.uri.toString();
            }
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        String rc = this.getName();
        if (rc == null) {
            rc = super.toString();
        }
        return rc;
    }

    public boolean isDisableAsyncDispatch() {
        return this.disableAsyncDispatch;
    }

    public void setDisableAsyncDispatch(boolean disableAsyncDispatch) {
        this.disableAsyncDispatch = disableAsyncDispatch;
    }

    public boolean isEnableStatusMonitor() {
        return this.enableStatusMonitor;
    }

    public void setEnableStatusMonitor(boolean enableStatusMonitor) {
        this.enableStatusMonitor = enableStatusMonitor;
    }
}

