/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTopicSendReceiveWithTwoConnectionsTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class QueueMasterSlaveTest
extends JmsTopicSendReceiveWithTwoConnectionsTest {
    protected BrokerService master;
    protected BrokerService slave;
    protected int inflightMessageCount = 0;
    protected int failureCount = 50;
    protected String uriString = "failover://(tcp://localhost:62001,tcp://localhost:62002)?randomize=false";

    protected void setUp() throws Exception {
        this.failureCount = this.messageCount / 2;
        this.topic = this.isTopic();
        BrokerFactoryBean brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getMasterXml()));
        brokerFactory.afterPropertiesSet();
        this.master = brokerFactory.getBroker();
        brokerFactory = new BrokerFactoryBean((Resource)new ClassPathResource(this.getSlaveXml()));
        brokerFactory.afterPropertiesSet();
        this.slave = brokerFactory.getBroker();
        this.master.start();
        this.slave.start();
        Thread.sleep(1000L);
        super.setUp();
    }

    protected String getSlaveXml() {
        return "org/apache/activemq/broker/ft/slave.xml";
    }

    protected String getMasterXml() {
        return "org/apache/activemq/broker/ft/master.xml";
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.slave.stop();
        this.master.stop();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }

    protected void messageSent() throws Exception {
        if (++this.inflightMessageCount >= this.failureCount) {
            this.inflightMessageCount = 0;
            Thread.sleep(1000L);
            this.master.stop();
        }
    }

    protected boolean isTopic() {
        return false;
    }
}

