/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.ft;

import java.io.File;
import java.net.URISyntaxException;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTopicTransactionTest;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.kahadaptor.KahaPersistenceAdapter;
import org.apache.activemq.test.JmsResourceProvider;

public class TransactedTopicMasterSlaveTest
extends JmsTopicTransactionTest {
    protected BrokerService slave;
    protected int inflightMessageCount = 0;
    protected int failureCount = 50;
    protected String uriString = "failover://(tcp://localhost:62001,tcp://localhost:62002)?randomize=false";

    protected void setUp() throws Exception {
        this.failureCount = this.batchCount / 2;
        this.broker = this.createBroker();
        this.broker.start();
        KahaPersistenceAdapter adaptor = new KahaPersistenceAdapter(new File("activemq-data/slave"));
        this.slave = new BrokerService();
        this.slave.setBrokerName("slave");
        this.slave.setPersistenceAdapter(adaptor);
        this.slave.addConnector("tcp://localhost:62002");
        this.slave.setDeleteAllMessagesOnStartup(true);
        this.slave.setMasterConnectorURI("tcp://localhost:62001");
        this.slave.start();
        Thread.sleep(1000L);
        this.resourceProvider = this.getJmsResourceProvider();
        this.topic = this.resourceProvider.isTopic();
        this.resourceProvider.setTransacted(true);
        this.connectionFactory = this.resourceProvider.createConnectionFactory();
        this.reconnect();
    }

    protected void tearDown() throws Exception {
        this.slave.stop();
        this.slave = null;
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception, URISyntaxException {
        BrokerService broker = new BrokerService();
        broker.setBrokerName("master");
        KahaPersistenceAdapter adaptor = new KahaPersistenceAdapter(new File("activemq-data/master"));
        broker.setPersistenceAdapter(adaptor);
        broker.addConnector("tcp://localhost:62001");
        broker.setDeleteAllMessagesOnStartup(true);
        return broker;
    }

    protected JmsResourceProvider getJmsResourceProvider() {
        JmsResourceProvider p = super.getJmsResourceProvider();
        p.setServerUri(this.uriString);
        return p;
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory(this.uriString);
    }

    protected void messageSent() throws Exception {
    }
}

