/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.io.IOException;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.TransportConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.broker.jmx.ConnectionView;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.JMXSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagedTransportConnection
extends TransportConnection {
    private static final Log log = LogFactory.getLog(ManagedTransportConnection.class);
    private final MBeanServer server;
    private final ObjectName connectorName;
    private ConnectionViewMBean mbean;
    private ObjectName byClientIdName;
    private ObjectName byAddressName;

    public ManagedTransportConnection(TransportConnector connector, Transport transport, Broker broker, TaskRunnerFactory factory, MBeanServer server, ObjectName connectorName) throws IOException {
        super(connector, transport, broker, factory);
        this.server = server;
        this.connectorName = connectorName;
        this.mbean = new ConnectionView(this);
        this.byAddressName = this.createByAddressObjectName("address", transport.getRemoteAddress());
        this.registerMBean(this.byAddressName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws Exception {
        if (this.isStarting()) {
            this.setPendingStop(true);
            return;
        }
        ManagedTransportConnection managedTransportConnection = this;
        synchronized (managedTransportConnection) {
            this.unregisterMBean(this.byClientIdName);
            this.unregisterMBean(this.byAddressName);
            this.byClientIdName = null;
            this.byAddressName = null;
        }
        super.stop();
    }

    public void setConnectionId(String connectionId) throws IOException {
    }

    public Response processAddConnection(ConnectionInfo info) throws Exception {
        Response answer = super.processAddConnection(info);
        String clientId = info.getClientId();
        if (clientId != null && this.byClientIdName == null) {
            this.byClientIdName = this.createByClientIdObjectName(clientId);
            this.registerMBean(this.byClientIdName);
        }
        return answer;
    }

    protected void registerMBean(ObjectName name) {
        if (name != null) {
            try {
                this.server.registerMBean(this.mbean, name);
            }
            catch (Throwable e) {
                log.warn("Failed to register MBean: " + name);
                log.debug("Failure reason: " + e, e);
            }
        }
    }

    protected void unregisterMBean(ObjectName name) {
        if (name != null) {
            try {
                this.server.unregisterMBean(name);
            }
            catch (Throwable e) {
                log.warn("Failed to unregister mbean: " + name);
                log.debug("Failure reason: " + e, e);
            }
        }
    }

    protected ObjectName createByAddressObjectName(String type, String value) throws IOException {
        Hashtable<String, String> map = this.connectorName.getKeyPropertyList();
        try {
            return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(map.get("BrokerName")) + "," + "Type=Connection," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(map.get("ConnectorName")) + "," + "ViewType=" + JMXSupport.encodeObjectNamePart(type) + "," + "Name=" + JMXSupport.encodeObjectNamePart(value));
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }

    protected ObjectName createByClientIdObjectName(String value) throws IOException {
        Hashtable<String, String> map = this.connectorName.getKeyPropertyList();
        try {
            return new ObjectName(this.connectorName.getDomain() + ":" + "BrokerName=" + JMXSupport.encodeObjectNamePart(map.get("BrokerName")) + "," + "Type=Connection," + "ConnectorName=" + JMXSupport.encodeObjectNamePart(map.get("ConnectorName")) + "," + "Connection=" + JMXSupport.encodeObjectNamePart(value));
        }
        catch (Throwable e) {
            throw IOExceptionSupport.create(e);
        }
    }
}

