/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.policy;

import java.util.Iterator;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.QueueSubscriptionTest;
import org.apache.activemq.broker.region.policy.PolicyEntry;
import org.apache.activemq.broker.region.policy.PolicyMap;
import org.apache.activemq.broker.region.policy.SimpleDispatchPolicy;
import org.apache.activemq.util.MessageIdList;

public class SimpleDispatchPolicyTest
extends QueueSubscriptionTest {
    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        PolicyEntry policy = new PolicyEntry();
        policy.setDispatchPolicy(new SimpleDispatchPolicy());
        PolicyMap pMap = new PolicyMap();
        pMap.setDefaultEntry(policy);
        broker.setDestinationPolicy(pMap);
        return broker;
    }

    public void testOneProducerTwoConsumersSmallMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersSmallMessagesLargePrefetch();
        this.assertOneConsumerReceivedAllMessages(this.messageCount);
    }

    public void testOneProducerTwoConsumersLargeMessagesLargePrefetch() throws Exception {
        super.testOneProducerTwoConsumersLargeMessagesLargePrefetch();
        this.assertOneConsumerReceivedAllMessages(this.messageCount);
    }

    public void assertOneConsumerReceivedAllMessages(int messageCount) throws Exception {
        boolean found = false;
        Iterator i = this.consumers.keySet().iterator();
        while (i.hasNext()) {
            MessageIdList messageIdList = (MessageIdList)this.consumers.get(i.next());
            int count = messageIdList.getMessageCount();
            if (count <= 0) continue;
            if (found) {
                SimpleDispatchPolicyTest.fail((String)"No other consumers should have received any messages");
                continue;
            }
            SimpleDispatchPolicyTest.assertEquals((String)"Consumer should have received all messages.", (int)messageCount, (int)count);
            found = true;
        }
        if (!found) {
            SimpleDispatchPolicyTest.fail((String)"At least one consumer should have received all messages");
        }
    }
}

