/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.AbstractSubscription;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerControl;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageDispatchNotification;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.MessagePull;
import org.apache.activemq.command.Response;
import org.apache.activemq.thread.Scheduler;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class PrefetchSubscription
extends AbstractSubscription {
    private static final Log log = LogFactory.getLog(PrefetchSubscription.class);
    protected final PendingMessageCursor pending;
    protected final LinkedList dispatched = new LinkedList();
    protected int prefetchExtension = 0;
    boolean dispatching = false;
    long enqueueCounter;
    long dispatchCounter;
    long dequeueCounter;

    public PrefetchSubscription(Broker broker, ConnectionContext context, ConsumerInfo info, PendingMessageCursor cursor) throws InvalidSelectorException {
        super(broker, context, info);
        this.pending = cursor;
    }

    public PrefetchSubscription(Broker broker, ConnectionContext context, ConsumerInfo info) throws InvalidSelectorException {
        this(broker, context, info, new VMPendingMessageCursor());
    }

    public synchronized Response pullMessage(ConnectionContext context, MessagePull pull) throws Exception {
        if (this.getPrefetchSize() == 0 && !this.isSlaveBroker()) {
            ++this.prefetchExtension;
            final long dispatchCounterBeforePull = this.dispatchCounter;
            this.dispatchMatched();
            if (dispatchCounterBeforePull == this.dispatchCounter) {
                if (pull.getTimeout() == -1L) {
                    this.add(QueueMessageReference.NULL_MESSAGE);
                    this.dispatchMatched();
                }
                if (pull.getTimeout() > 0L) {
                    Scheduler.executeAfterDelay(new Runnable(){

                        public void run() {
                            PrefetchSubscription.this.pullTimeout(dispatchCounterBeforePull);
                        }
                    }, pull.getTimeout());
                }
            }
        }
        return null;
    }

    private synchronized void pullTimeout(long dispatchCounterBeforePull) {
        if (dispatchCounterBeforePull == this.dispatchCounter) {
            try {
                this.add(QueueMessageReference.NULL_MESSAGE);
                this.dispatchMatched();
            }
            catch (Exception e) {
                this.context.getConnection().serviceException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void add(MessageReference node) throws Exception {
        ++this.enqueueCounter;
        if (!this.isFull() && this.pending.isEmpty()) {
            this.dispatch(node);
        } else {
            this.optimizePrefetch();
            PendingMessageCursor pendingMessageCursor = this.pending;
            synchronized (pendingMessageCursor) {
                if (this.pending.isEmpty()) {
                    log.debug("Prefetch limit.");
                }
                this.pending.addMessageLast(node);
            }
        }
    }

    public synchronized void processMessageDispatchNotification(MessageDispatchNotification mdn) throws Exception {
        PendingMessageCursor pendingMessageCursor = this.pending;
        synchronized (pendingMessageCursor) {
            this.pending.reset();
            while (this.pending.hasNext()) {
                MessageReference node = this.pending.next();
                if (!node.getMessageId().equals(mdn.getMessageId())) continue;
                this.pending.remove();
                this.createMessageDispatch(node, node.getMessage());
                this.dispatched.addLast(node);
                return;
            }
            throw new JMSException("Slave broker out of sync with master: Dispatched message (" + mdn.getMessageId() + ") was not in the pending list: " + this.pending);
        }
    }

    public synchronized void acknowledge(ConnectionContext context, MessageAck ack) throws Exception {
        if (ack.isStandardAck()) {
            int index = 0;
            boolean inAckRange = false;
            Iterator iter = this.dispatched.iterator();
            while (iter.hasNext()) {
                final MessageReference node = (MessageReference)iter.next();
                MessageId messageId = node.getMessageId();
                if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                    inAckRange = true;
                }
                if (!inAckRange) continue;
                if (!context.isInTransaction()) {
                    ++this.dequeueCounter;
                    node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                    iter.remove();
                } else {
                    context.getTransaction().addSynchronization(new Synchronization(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void afterCommit() throws Exception {
                            PrefetchSubscription prefetchSubscription = PrefetchSubscription.this;
                            synchronized (prefetchSubscription) {
                                ++PrefetchSubscription.this.dequeueCounter;
                                PrefetchSubscription.this.dispatched.remove(node);
                                node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                                PrefetchSubscription.this.prefetchExtension = Math.max(0, PrefetchSubscription.this.prefetchExtension - 1);
                            }
                        }

                        public void afterRollback() throws Exception {
                            super.afterRollback();
                        }
                    });
                }
                ++index;
                this.acknowledge(context, ack, node);
                if (!ack.getLastMessageId().equals(messageId)) continue;
                if (context.isInTransaction()) {
                    if (this.getPrefetchSize() != 0) {
                        this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                    }
                } else {
                    this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                }
                this.dispatchMatched();
                return;
            }
            log.info("Could not correlate acknowledgment with dispatched message: " + ack);
        } else {
            if (ack.isDeliveredAck()) {
                int index = 0;
                Iterator iter = this.dispatched.iterator();
                while (iter.hasNext()) {
                    MessageReference node = (MessageReference)iter.next();
                    if (ack.getLastMessageId().equals(node.getMessageId())) {
                        this.prefetchExtension = Math.max(this.prefetchExtension, index + 1);
                        this.dispatchMatched();
                        return;
                    }
                    ++index;
                }
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
            if (ack.isPoisonAck()) {
                if (ack.isInTransaction()) {
                    throw new JMSException("Poison ack cannot be transacted: " + ack);
                }
                int index = 0;
                boolean inAckRange = false;
                Iterator iter = this.dispatched.iterator();
                while (iter.hasNext()) {
                    MessageReference node = (MessageReference)iter.next();
                    MessageId messageId = node.getMessageId();
                    if (ack.getFirstMessageId() == null || ack.getFirstMessageId().equals(messageId)) {
                        inAckRange = true;
                    }
                    if (!inAckRange) continue;
                    this.sendToDLQ(context, node);
                    node.getRegionDestination().getDestinationStatistics().getDequeues().increment();
                    iter.remove();
                    ++this.dequeueCounter;
                    ++index;
                    this.acknowledge(context, ack, node);
                    if (!ack.getLastMessageId().equals(messageId)) continue;
                    this.prefetchExtension = Math.max(0, this.prefetchExtension - (index + 1));
                    this.dispatchMatched();
                    return;
                }
                throw new JMSException("Could not correlate acknowledgment with dispatched message: " + ack);
            }
        }
        if (this.isSlaveBroker()) {
            throw new JMSException("Slave broker out of sync with master: Acknowledgment (" + ack + ") was not in the dispatch list: " + this.dispatched);
        }
        log.debug("Acknowledgment out of sync (Normally occurs when failover connection reconnects): " + ack);
    }

    protected void sendToDLQ(ConnectionContext context, MessageReference node) throws IOException, Exception {
        Message message = node.getMessage();
        if (message != null) {
            DeadLetterStrategy deadLetterStrategy = node.getRegionDestination().getDeadLetterStrategy();
            ActiveMQDestination deadLetterDestination = deadLetterStrategy.getDeadLetterQueueFor(message.getDestination());
            BrokerSupport.resend(context, message, deadLetterDestination);
        }
    }

    protected boolean isFull() {
        return this.isSlaveBroker() || this.dispatched.size() - this.prefetchExtension >= this.info.getPrefetchSize();
    }

    public boolean isLowWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) <= (double)this.info.getPrefetchSize() * 0.4;
    }

    public boolean isHighWaterMark() {
        return (double)(this.dispatched.size() - this.prefetchExtension) >= (double)this.info.getPrefetchSize() * 0.9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingQueueSize() {
        PendingMessageCursor pendingMessageCursor = this.pending;
        synchronized (pendingMessageCursor) {
            return this.pending.size();
        }
    }

    public synchronized int getDispatchedQueueSize() {
        return this.dispatched.size();
    }

    public synchronized long getDequeueCounter() {
        return this.dequeueCounter;
    }

    public synchronized long getDispatchedCounter() {
        return this.dispatchCounter;
    }

    public synchronized long getEnqueueCounter() {
        return this.enqueueCounter;
    }

    public boolean isRecoveryRequired() {
        return this.pending.isRecoveryRequired();
    }

    public void optimizePrefetch() {
    }

    public void add(ConnectionContext context, Destination destination) throws Exception {
        super.add(context, destination);
        this.pending.add(context, destination);
    }

    public void remove(ConnectionContext context, Destination destination) throws Exception {
        super.remove(context, destination);
        this.pending.remove(context, destination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatchMatched() throws IOException {
        if (!this.dispatching) {
            this.dispatching = true;
            try {
                this.pending.reset();
                while (this.pending.hasNext() && !this.isFull()) {
                    MessageReference node = this.pending.next();
                    this.pending.remove();
                    this.dispatch(node);
                }
            }
            finally {
                this.dispatching = false;
            }
        }
    }

    protected boolean dispatch(final MessageReference node) throws IOException {
        final Message message = node.getMessage();
        if (message == null) {
            return false;
        }
        if (this.canDispatch(node) && !this.isSlaveBroker()) {
            MessageDispatch md = this.createMessageDispatch(node, message);
            if (node != QueueMessageReference.NULL_MESSAGE) {
                ++this.dispatchCounter;
                this.dispatched.addLast(node);
            } else {
                this.prefetchExtension = Math.max(0, this.prefetchExtension - 1);
            }
            if (this.info.isDispatchAsync()) {
                md.setTransmitCallback(new Runnable(){

                    public void run() {
                        PrefetchSubscription.this.onDispatch(node, message);
                    }
                });
                this.context.getConnection().dispatchAsync(md);
            } else {
                this.context.getConnection().dispatchSync(md);
                this.onDispatch(node, message);
            }
            return true;
        }
        return false;
    }

    protected synchronized void onDispatch(MessageReference node, Message message) {
        if (node.getRegionDestination() != null) {
            if (node != QueueMessageReference.NULL_MESSAGE) {
                node.getRegionDestination().getDestinationStatistics().getDispatched().increment();
            }
            try {
                this.dispatchMatched();
            }
            catch (IOException e) {
                this.context.getConnection().serviceExceptionAsync(e);
            }
        }
    }

    public void updateConsumerPrefetch(int newPrefetch) {
        if (this.context != null && this.context.getConnection() != null && this.context.getConnection().isManageable()) {
            ConsumerControl cc = new ConsumerControl();
            cc.setConsumerId(this.info.getConsumerId());
            cc.setPrefetch(newPrefetch);
            this.context.getConnection().dispatchAsync(cc);
        }
    }

    protected MessageDispatch createMessageDispatch(MessageReference node, Message message) {
        if (node == QueueMessageReference.NULL_MESSAGE) {
            MessageDispatch md = new MessageDispatch();
            md.setMessage(null);
            md.setConsumerId(this.info.getConsumerId());
            md.setDestination(null);
            return md;
        }
        MessageDispatch md = new MessageDispatch();
        md.setConsumerId(this.info.getConsumerId());
        md.setDestination(node.getRegionDestination().getActiveMQDestination());
        md.setMessage(message);
        md.setRedeliveryCounter(node.getRedeliveryCounter());
        return md;
    }

    protected abstract boolean canDispatch(MessageReference var1) throws IOException;

    protected void acknowledge(ConnectionContext context, MessageAck ack, MessageReference node) throws IOException {
    }
}

