/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArrayList;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ResourceAllocationException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.DestinationStatistics;
import org.apache.activemq.broker.region.IndirectMessageReference;
import org.apache.activemq.broker.region.LockOwner;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.MessageReferenceFilter;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.cursors.VMPendingMessageCursor;
import org.apache.activemq.broker.region.group.MessageGroupHashBucketFactory;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.group.MessageGroupMapFactory;
import org.apache.activemq.broker.region.group.MessageGroupSet;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.RoundRobinDispatchPolicy;
import org.apache.activemq.broker.region.policy.SharedDeadLetterStrategy;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.Response;
import org.apache.activemq.filter.BooleanExpression;
import org.apache.activemq.filter.MessageEvaluationContext;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.selector.SelectorParser;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.thread.TaskRunnerFactory;
import org.apache.activemq.thread.Valve;
import org.apache.activemq.transaction.Synchronization;
import org.apache.activemq.util.BrokerSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Queue
implements Destination {
    private final Log log;
    protected final ActiveMQDestination destination;
    protected final List consumers = new CopyOnWriteArrayList();
    protected final Valve dispatchValve = new Valve(true);
    protected final UsageManager usageManager;
    protected final DestinationStatistics destinationStatistics = new DestinationStatistics();
    protected PendingMessageCursor messages = new VMPendingMessageCursor();
    private LockOwner exclusiveOwner;
    private MessageGroupMap messageGroupOwners;
    protected long garbageSize = 0L;
    protected long garbageSizeBeforeCollection = 1000L;
    private DispatchPolicy dispatchPolicy = new RoundRobinDispatchPolicy();
    protected final MessageStore store;
    protected int highestSubscriptionPriority;
    private DeadLetterStrategy deadLetterStrategy = new SharedDeadLetterStrategy();
    private MessageGroupMapFactory messageGroupMapFactory = new MessageGroupHashBucketFactory();
    static ThreadPoolExecutor threadPool = new ThreadPoolExecutor(1, 10, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue());

    public Queue(ActiveMQDestination destination, UsageManager memoryManager, MessageStore store, DestinationStatistics parentStats, TaskRunnerFactory taskFactory) throws Exception {
        this.destination = destination;
        this.usageManager = new UsageManager(memoryManager);
        this.usageManager.setLimit(Long.MAX_VALUE);
        this.store = store;
        if (store != null) {
            store.setUsageManager(this.usageManager);
        }
        this.destinationStatistics.setParent(parentStats);
        this.log = LogFactory.getLog(this.getClass().getName() + "." + destination.getPhysicalName());
    }

    public void initialize() throws Exception {
        if (this.store != null) {
            this.store.recover(new MessageRecoveryListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void recoverMessage(Message message) {
                    message.setRegionDestination(Queue.this);
                    MessageReference reference = Queue.this.createMessageReference(message);
                    PendingMessageCursor pendingMessageCursor = Queue.this.messages;
                    synchronized (pendingMessageCursor) {
                        try {
                            Queue.this.messages.addMessageLast(reference);
                        }
                        catch (Exception e) {
                            Queue.this.log.fatal("Failed to add message to cursor", e);
                        }
                    }
                    reference.decrementReferenceCount();
                    Queue.this.destinationStatistics.getMessages().increment();
                }

                public void recoverMessageReference(String messageReference) throws Exception {
                    throw new RuntimeException("Should not be called.");
                }

                public void finished() {
                }
            });
        }
    }

    public synchronized boolean lock(MessageReference node, LockOwner lockOwner) {
        if (this.exclusiveOwner == lockOwner) {
            return true;
        }
        if (this.exclusiveOwner != null) {
            return false;
        }
        if (lockOwner.getLockPriority() < this.highestSubscriptionPriority) {
            return false;
        }
        if (lockOwner.isLockExclusive()) {
            this.exclusiveOwner = lockOwner;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscription(ConnectionContext context, Subscription sub) throws Exception {
        sub.add(context, this);
        this.destinationStatistics.getConsumers().increment();
        this.dispatchValve.turnOff();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            Object object = this.consumers;
            synchronized (object) {
                this.consumers.add(sub);
            }
            this.highestSubscriptionPriority = this.calcHighestSubscriptionPriority();
            msgContext.setDestination(this.destination);
            object = this.messages;
            synchronized (object) {
                this.messages.reset();
                while (this.messages.hasNext()) {
                    QueueMessageReference node = (QueueMessageReference)this.messages.next();
                    if (node.isDropped()) continue;
                    try {
                        msgContext.setMessageReference(node);
                        if (!sub.matches(node, msgContext)) continue;
                        sub.add(node);
                    }
                    catch (IOException e) {
                        this.log.warn("Could not load message: " + e, e);
                    }
                }
            }
        }
        finally {
            msgContext.clear();
            this.dispatchValve.turnOn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscription(ConnectionContext context, Subscription sub) throws Exception {
        block15: {
            this.destinationStatistics.getConsumers().decrement();
            this.dispatchValve.turnOff();
            try {
                List list = this.consumers;
                synchronized (list) {
                    this.consumers.remove(sub);
                }
                sub.remove(context, this);
                this.highestSubscriptionPriority = this.calcHighestSubscriptionPriority();
                boolean wasExclusiveOwner = false;
                if (this.exclusiveOwner == sub) {
                    this.exclusiveOwner = null;
                    wasExclusiveOwner = true;
                }
                ConsumerId consumerId = sub.getConsumerInfo().getConsumerId();
                MessageGroupSet ownedGroups = this.getMessageGroupOwners().removeConsumer(consumerId);
                if (sub.getConsumerInfo().isBrowser()) break block15;
                MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
                try {
                    QueueMessageReference node;
                    msgContext.setDestination(this.destination);
                    ArrayList<QueueMessageReference> messagesToDispatch = new ArrayList<QueueMessageReference>();
                    PendingMessageCursor pendingMessageCursor = this.messages;
                    synchronized (pendingMessageCursor) {
                        this.messages.reset();
                        while (this.messages.hasNext()) {
                            node = (QueueMessageReference)this.messages.next();
                            if (node.isDropped()) continue;
                            String groupID = node.getGroupID();
                            if (node.getLockOwner() != sub && !wasExclusiveOwner && (groupID == null || !ownedGroups.contains(groupID))) continue;
                            messagesToDispatch.add(node);
                        }
                    }
                    Iterator iter = messagesToDispatch.iterator();
                    while (iter.hasNext()) {
                        node = (QueueMessageReference)iter.next();
                        node.incrementRedeliveryCounter();
                        node.unlock();
                        msgContext.setMessageReference(node);
                        this.dispatchPolicy.dispatch(context, node, msgContext, this.consumers);
                    }
                }
                finally {
                    msgContext.clear();
                }
            }
            finally {
                this.dispatchValve.turnOn();
            }
        }
    }

    public void send(final ConnectionContext context, final Message message) throws Exception {
        if (context.isProducerFlowControl()) {
            if (message.isResponseRequired() || context.isNetworkConnection()) {
                Runnable callback;
                if (this.usageManager.isFull() && this.usageManager.notifyCallbackWhenNotFull(callback = new Runnable(){

                    public void run() {
                        threadPool.execute(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                try {
                                    Queue.this.sendMessage(context, message);
                                    Response response = new Response();
                                    response.setCorrelationId(message.getCommandId());
                                    context.getConnection().dispatchAsync(response);
                                }
                                catch (Exception e) {
                                    ExceptionResponse response = new ExceptionResponse(e);
                                    response.setCorrelationId(message.getCommandId());
                                    context.getConnection().dispatchAsync(response);
                                }
                            }
                        });
                    }
                })) {
                    context.setDontSendReponse(true);
                    return;
                }
            } else {
                if (this.usageManager.isSendFailIfNoSpace()) {
                    throw new ResourceAllocationException("Usage Manager memory limit reached");
                }
                while (!this.usageManager.waitForSpace(1000L)) {
                    if (!context.getStopping().get()) continue;
                    throw new IOException("Connection closed, send aborted.");
                }
            }
        }
        this.sendMessage(context, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMessage(final ConnectionContext context, final Message message) throws IOException, Exception {
        message.setRegionDestination(this);
        if (this.store != null && message.isPersistent()) {
            this.store.addMessage(context, message);
        }
        final MessageReference node = this.createMessageReference(message);
        try {
            if (context.isInTransaction()) {
                context.getTransaction().addSynchronization(new Synchronization(){

                    public void afterCommit() throws Exception {
                        Queue.this.dispatch(context, node, message);
                    }
                });
            } else {
                this.dispatch(context, node, message);
            }
        }
        finally {
            node.decrementReferenceCount();
        }
    }

    public void dispose(ConnectionContext context) throws IOException {
        if (this.store != null) {
            this.store.removeAllMessages(context);
        }
        this.destinationStatistics.setParent(null);
    }

    public void dropEvent() {
        this.dropEvent(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropEvent(boolean skipGc) {
        this.destinationStatistics.getMessages().decrement();
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            ++this.garbageSize;
            if (!skipGc && this.garbageSize > this.garbageSizeBeforeCollection) {
                this.gc();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gc() {
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.resetForGC();
            while (this.messages.hasNext()) {
                QueueMessageReference node = (QueueMessageReference)this.messages.next();
                if (!node.isDropped()) continue;
                --this.garbageSize;
                this.messages.remove();
            }
        }
    }

    public void acknowledge(ConnectionContext context, Subscription sub, MessageAck ack, MessageReference node) throws IOException {
        if (this.store != null && node.isPersistent()) {
            if (ack.getMessageCount() > 0) {
                MessageAck a = new MessageAck();
                ack.copy(a);
                ack = a;
                ack.setFirstMessageId(node.getMessageId());
                ack.setLastMessageId(node.getMessageId());
                ack.setMessageCount(1);
            }
            this.store.removeMessage(context, ack);
        }
    }

    Message loadMessage(MessageId messageId) throws IOException {
        Message msg = this.store.getMessage(messageId);
        if (msg != null) {
            msg.setRegionDestination(this);
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = 0;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            size = this.messages.size();
        }
        return "Queue: destination=" + this.destination.getPhysicalName() + ", subscriptions=" + this.consumers.size() + ", memory=" + this.usageManager.getPercentUsage() + "%, size=" + size + ", in flight groups=" + this.messageGroupOwners;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public ActiveMQDestination getActiveMQDestination() {
        return this.destination;
    }

    public String getDestination() {
        return this.destination.getPhysicalName();
    }

    public UsageManager getUsageManager() {
        return this.usageManager;
    }

    public DestinationStatistics getDestinationStatistics() {
        return this.destinationStatistics;
    }

    public MessageGroupMap getMessageGroupOwners() {
        if (this.messageGroupOwners == null) {
            this.messageGroupOwners = this.getMessageGroupMapFactory().createMessageGroupMap();
        }
        return this.messageGroupOwners;
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy dispatchPolicy) {
        this.dispatchPolicy = dispatchPolicy;
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public MessageGroupMapFactory getMessageGroupMapFactory() {
        return this.messageGroupMapFactory;
    }

    public void setMessageGroupMapFactory(MessageGroupMapFactory messageGroupMapFactory) {
        this.messageGroupMapFactory = messageGroupMapFactory;
    }

    public String getName() {
        return this.getActiveMQDestination().getPhysicalName();
    }

    public PendingMessageCursor getMessages() {
        return this.messages;
    }

    public void setMessages(PendingMessageCursor messages) {
        this.messages = messages;
    }

    private MessageReference createMessageReference(Message message) {
        return new IndirectMessageReference(this, this.store, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispatch(ConnectionContext context, MessageReference node, Message message) throws Exception {
        this.dispatchValve.increment();
        MessageEvaluationContext msgContext = context.getMessageEvaluationContext();
        try {
            this.destinationStatistics.getEnqueues().increment();
            this.destinationStatistics.getMessages().increment();
            Object object = this.messages;
            synchronized (object) {
                this.messages.addMessageLast(node);
            }
            object = this.consumers;
            synchronized (object) {
                if (this.consumers.isEmpty()) {
                    this.log.debug("No subscriptions registered, will not dispatch message at this time.");
                    return;
                }
            }
            msgContext.setDestination(this.destination);
            msgContext.setMessageReference(node);
            this.dispatchPolicy.dispatch(context, node, msgContext, this.consumers);
            return;
        }
        finally {
            msgContext.clear();
            this.dispatchValve.decrement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calcHighestSubscriptionPriority() {
        byte by;
        int n = Integer.MIN_VALUE;
        List list = this.consumers;
        synchronized (list) {
            Iterator iter = this.consumers.iterator();
            while (iter.hasNext()) {
                Subscription sub = (Subscription)iter.next();
                if (sub.getConsumerInfo().getPriority() <= by) continue;
                by = sub.getConsumerInfo().getPriority();
            }
        }
        return by;
    }

    MessageStore getMessageStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message[] browse() {
        ArrayList<Message> l = new ArrayList<Message>();
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.reset();
            while (this.messages.hasNext()) {
                try {
                    MessageReference r = this.messages.next();
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        if (m == null) continue;
                        l.add(m);
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return l.toArray(new Message[l.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message getMessage(String messageId) {
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.reset();
            while (this.messages.hasNext()) {
                try {
                    MessageReference r = this.messages.next();
                    if (!messageId.equals(r.getMessageId().toString())) continue;
                    r.incrementReferenceCount();
                    try {
                        Message m = r.getMessage();
                        if (m == null) return null;
                        Message message = m;
                        return message;
                    }
                    finally {
                        r.decrementReferenceCount();
                    }
                }
                catch (IOException iOException) {
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            ConnectionContext c = this.createConnectionContext();
            this.messages.reset();
            while (this.messages.hasNext()) {
                try {
                    QueueMessageReference r = (QueueMessageReference)this.messages.next();
                    if (!r.lock(LockOwner.HIGH_PRIORITY_LOCK_OWNER)) continue;
                    MessageAck ack = new MessageAck();
                    ack.setAckType((byte)2);
                    ack.setDestination(this.destination);
                    ack.setMessageID(r.getMessageId());
                    this.acknowledge(c, null, ack, r);
                    r.drop();
                    this.dropEvent(true);
                }
                catch (IOException iOException) {}
            }
            this.gc();
        }
    }

    public boolean removeMessage(String messageId) throws Exception {
        return this.removeMatchingMessages(this.createMessageIdFilter(messageId), 1) > 0;
    }

    public int removeMatchingMessages(String selector) throws Exception {
        return this.removeMatchingMessages(selector, -1);
    }

    public int removeMatchingMessages(String selector, int maximumMessages) throws Exception {
        return this.removeMatchingMessages(this.createSelectorFilter(selector), maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeMatchingMessages(MessageReferenceFilter filter, int maximumMessages) throws Exception {
        int counter = 0;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            ConnectionContext c = this.createConnectionContext();
            this.messages.reset();
            while (this.messages.hasNext()) {
                IndirectMessageReference r = (IndirectMessageReference)this.messages.next();
                if (!filter.evaluate(c, r) || !this.lockMessage(r)) continue;
                this.removeMessage(c, r);
                if (++counter < maximumMessages || maximumMessages <= 0) continue;
                break;
            }
        }
        return counter;
    }

    public boolean copyMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessages(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.copyMatchingMessagesTo(context, selector, dest, -1);
    }

    public int copyMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.copyMatchingMessages(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int copyMatchingMessages(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        int counter = 0;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.reset();
            while (this.messages.hasNext()) {
                MessageReference r = this.messages.next();
                if (!filter.evaluate(context, r)) continue;
                r.incrementReferenceCount();
                try {
                    Message m = r.getMessage();
                    BrokerSupport.resend(context, m, dest);
                    if (++counter < maximumMessages || maximumMessages <= 0) continue;
                    break;
                }
                finally {
                    r.decrementReferenceCount();
                }
            }
        }
        return counter;
    }

    public boolean moveMessageTo(ConnectionContext context, String messageId, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createMessageIdFilter(messageId), dest, 1) > 0;
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest) throws Exception {
        return this.moveMatchingMessagesTo(context, selector, dest, -1);
    }

    public int moveMatchingMessagesTo(ConnectionContext context, String selector, ActiveMQDestination dest, int maximumMessages) throws Exception {
        return this.moveMatchingMessagesTo(context, this.createSelectorFilter(selector), dest, maximumMessages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveMatchingMessagesTo(ConnectionContext context, MessageReferenceFilter filter, ActiveMQDestination dest, int maximumMessages) throws Exception {
        int counter = 0;
        PendingMessageCursor pendingMessageCursor = this.messages;
        synchronized (pendingMessageCursor) {
            this.messages.reset();
            while (this.messages.hasNext()) {
                IndirectMessageReference r = (IndirectMessageReference)this.messages.next();
                if (!filter.evaluate(context, r) || !this.lockMessage(r)) continue;
                r.incrementReferenceCount();
                try {
                    Message m = r.getMessage();
                    BrokerSupport.resend(context, m, dest);
                    this.removeMessage(context, r);
                    if (++counter < maximumMessages || maximumMessages <= 0) continue;
                    break;
                }
                finally {
                    r.decrementReferenceCount();
                }
            }
        }
        return counter;
    }

    protected MessageReferenceFilter createMessageIdFilter(final String messageId) {
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) {
                return messageId.equals(r.getMessageId().toString());
            }
        };
    }

    protected MessageReferenceFilter createSelectorFilter(String selector) throws InvalidSelectorException {
        final BooleanExpression selectorExpression = new SelectorParser().parse(selector);
        return new MessageReferenceFilter(){

            public boolean evaluate(ConnectionContext context, MessageReference r) throws JMSException {
                MessageEvaluationContext messageEvaluationContext = context.getMessageEvaluationContext();
                messageEvaluationContext.setMessageReference(r);
                if (messageEvaluationContext.getDestination() == null) {
                    messageEvaluationContext.setDestination(Queue.this.getActiveMQDestination());
                }
                return selectorExpression.matches(messageEvaluationContext);
            }
        };
    }

    protected void removeMessage(ConnectionContext c, IndirectMessageReference r) throws IOException {
        MessageAck ack = new MessageAck();
        ack.setAckType((byte)2);
        ack.setDestination(this.destination);
        ack.setMessageID(r.getMessageId());
        this.acknowledge(c, null, ack, r);
        r.drop();
        this.dropEvent();
    }

    protected boolean lockMessage(IndirectMessageReference r) {
        return r.lock(LockOwner.HIGH_PRIORITY_LOCK_OWNER);
    }

    protected ConnectionContext createConnectionContext() {
        ConnectionContext answer = new ConnectionContext();
        answer.getMessageEvaluationContext().setDestination(this.getActiveMQDestination());
        return answer;
    }
}

