/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.policy;

import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.TopicSubscription;
import org.apache.activemq.broker.region.cursors.PendingMessageCursor;
import org.apache.activemq.broker.region.group.MessageGroupHashBucketFactory;
import org.apache.activemq.broker.region.group.MessageGroupMapFactory;
import org.apache.activemq.broker.region.policy.DeadLetterStrategy;
import org.apache.activemq.broker.region.policy.DispatchPolicy;
import org.apache.activemq.broker.region.policy.MessageEvictionStrategy;
import org.apache.activemq.broker.region.policy.PendingMessageLimitStrategy;
import org.apache.activemq.broker.region.policy.PendingQueueMessageStoragePolicy;
import org.apache.activemq.broker.region.policy.SubscriptionRecoveryPolicy;
import org.apache.activemq.filter.DestinationMapEntry;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyEntry
extends DestinationMapEntry {
    private static final Log log = LogFactory.getLog(PolicyEntry.class);
    private DispatchPolicy dispatchPolicy;
    private SubscriptionRecoveryPolicy subscriptionRecoveryPolicy;
    private boolean sendAdvisoryIfNoConsumers;
    private DeadLetterStrategy deadLetterStrategy;
    private PendingMessageLimitStrategy pendingMessageLimitStrategy;
    private MessageEvictionStrategy messageEvictionStrategy;
    private long memoryLimit;
    private MessageGroupMapFactory messageGroupMapFactory;
    private PendingQueueMessageStoragePolicy pendingQueueMessageStoragePolicy;

    public void configure(Queue queue) {
        if (this.dispatchPolicy != null) {
            queue.setDispatchPolicy(this.dispatchPolicy);
        }
        if (this.deadLetterStrategy != null) {
            queue.setDeadLetterStrategy(this.deadLetterStrategy);
        }
        queue.setMessageGroupMapFactory(this.getMessageGroupMapFactory());
        if (this.memoryLimit > 0L) {
            queue.getUsageManager().setLimit(this.memoryLimit);
        }
        if (this.pendingQueueMessageStoragePolicy != null) {
            PendingMessageCursor messages = this.pendingQueueMessageStoragePolicy.getQueuePendingMessageCursor();
            queue.setMessages(messages);
        }
    }

    public void configure(Topic topic) {
        if (this.dispatchPolicy != null) {
            topic.setDispatchPolicy(this.dispatchPolicy);
        }
        if (this.deadLetterStrategy != null) {
            topic.setDeadLetterStrategy(this.deadLetterStrategy);
        }
        if (this.subscriptionRecoveryPolicy != null) {
            topic.setSubscriptionRecoveryPolicy(this.subscriptionRecoveryPolicy.copy());
        }
        topic.setSendAdvisoryIfNoConsumers(this.sendAdvisoryIfNoConsumers);
        if (this.memoryLimit > 0L) {
            topic.getUsageManager().setLimit(this.memoryLimit);
        }
    }

    public void configure(TopicSubscription subscription) {
        if (this.pendingMessageLimitStrategy != null) {
            int value = this.pendingMessageLimitStrategy.getMaximumPendingMessageLimit(subscription);
            int consumerLimit = subscription.getInfo().getMaximumPendingMessageLimit();
            if (consumerLimit > 0 && (value < 0 || consumerLimit < value)) {
                value = consumerLimit;
            }
            if (value >= 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting the maximumPendingMessages size to: " + value + " for consumer: " + subscription.getInfo().getConsumerId());
                }
                subscription.setMaximumPendingMessages(value);
            }
        }
        if (this.messageEvictionStrategy != null) {
            subscription.setMessageEvictionStrategy(this.messageEvictionStrategy);
        }
    }

    public DispatchPolicy getDispatchPolicy() {
        return this.dispatchPolicy;
    }

    public void setDispatchPolicy(DispatchPolicy policy) {
        this.dispatchPolicy = policy;
    }

    public SubscriptionRecoveryPolicy getSubscriptionRecoveryPolicy() {
        return this.subscriptionRecoveryPolicy;
    }

    public void setSubscriptionRecoveryPolicy(SubscriptionRecoveryPolicy subscriptionRecoveryPolicy) {
        this.subscriptionRecoveryPolicy = subscriptionRecoveryPolicy;
    }

    public boolean isSendAdvisoryIfNoConsumers() {
        return this.sendAdvisoryIfNoConsumers;
    }

    public void setSendAdvisoryIfNoConsumers(boolean sendAdvisoryIfNoConsumers) {
        this.sendAdvisoryIfNoConsumers = sendAdvisoryIfNoConsumers;
    }

    public DeadLetterStrategy getDeadLetterStrategy() {
        return this.deadLetterStrategy;
    }

    public void setDeadLetterStrategy(DeadLetterStrategy deadLetterStrategy) {
        this.deadLetterStrategy = deadLetterStrategy;
    }

    public PendingMessageLimitStrategy getPendingMessageLimitStrategy() {
        return this.pendingMessageLimitStrategy;
    }

    public void setPendingMessageLimitStrategy(PendingMessageLimitStrategy pendingMessageLimitStrategy) {
        this.pendingMessageLimitStrategy = pendingMessageLimitStrategy;
    }

    public MessageEvictionStrategy getMessageEvictionStrategy() {
        return this.messageEvictionStrategy;
    }

    public void setMessageEvictionStrategy(MessageEvictionStrategy messageEvictionStrategy) {
        this.messageEvictionStrategy = messageEvictionStrategy;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public void setMemoryLimit(long memoryLimit) {
        this.memoryLimit = memoryLimit;
    }

    public MessageGroupMapFactory getMessageGroupMapFactory() {
        if (this.messageGroupMapFactory == null) {
            this.messageGroupMapFactory = new MessageGroupHashBucketFactory();
        }
        return this.messageGroupMapFactory;
    }

    public void setMessageGroupMapFactory(MessageGroupMapFactory messageGroupMapFactory) {
        this.messageGroupMapFactory = messageGroupMapFactory;
    }

    public PendingQueueMessageStoragePolicy getPendingQueueMessageStoragePolicy() {
        return this.pendingQueueMessageStoragePolicy;
    }

    public void setPendingQueueMessageStoragePolicy(PendingQueueMessageStoragePolicy pendingQueueMessageStoragePolicy) {
        this.pendingQueueMessageStoragePolicy = pendingQueueMessageStoragePolicy;
    }
}

