/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.store;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.JmsTestSupport;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.ProgressPrinter;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;

public class LoadTester
extends JmsTestSupport {
    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker(new URI("xbean:org/apache/activemq/broker/store/loadtester.xml"));
    }

    protected ConnectionFactory createConnectionFactory() throws URISyntaxException, IOException {
        ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(((TransportConnector)this.broker.getTransportConnectors().get(0)).getServer().getConnectURI());
        factory.setUseAsyncSend(true);
        return factory;
    }

    public void testQueueSendThenAddConsumer() throws Exception {
        int MESSAGE_SIZE = 65536;
        int PRODUCE_COUNT = 10000;
        ProgressPrinter printer = new ProgressPrinter(PRODUCE_COUNT, 20L);
        ActiveMQQueue destination = new ActiveMQQueue("TEST");
        this.connection.setUseCompression(false);
        this.connection.getPrefetchPolicy().setAll(10);
        this.connection.start();
        Session session = this.connection.createSession(false, 3);
        MessageProducer producer = session.createProducer(destination);
        producer.setDeliveryMode(2);
        log.info("Sending " + PRODUCE_COUNT + " messages that are " + (double)MESSAGE_SIZE / 1024.0 + "k large, for a total of " + (double)(PRODUCE_COUNT * MESSAGE_SIZE) / 1048576.0 + " megs of data.");
        long start = System.currentTimeMillis();
        for (int i = 0; i < PRODUCE_COUNT; ++i) {
            printer.increment();
            BytesMessage msg = session.createBytesMessage();
            msg.writeBytes(new byte[MESSAGE_SIZE]);
            producer.send(msg);
        }
        long end1 = System.currentTimeMillis();
        log.info("Produced messages/sec: " + (double)PRODUCE_COUNT * 1000.0 / (double)(end1 - start));
        printer = new ProgressPrinter(PRODUCE_COUNT, 10L);
        start = System.currentTimeMillis();
        MessageConsumer consumer = session.createConsumer(destination);
        for (int i = 0; i < PRODUCE_COUNT; ++i) {
            printer.increment();
            LoadTester.assertNotNull((String)("Getting message: " + i), (Object)consumer.receive(20000L));
        }
        end1 = System.currentTimeMillis();
        log.info("Consumed messages/sec: " + (double)PRODUCE_COUNT * 1000.0 / (double)(end1 - start));
    }

    public static Test suite() {
        return LoadTester.suite(LoadTester.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)LoadTester.suite());
    }
}

