/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.virtual;

import java.net.URI;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.activemq.EmbeddedBrokerTestSupport;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.spring.ConsumerBean;
import org.apache.activemq.xbean.XBeanBrokerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompositeQueueTest
extends EmbeddedBrokerTestSupport {
    private static final Log log = LogFactory.getLog(CompositeQueueTest.class);
    private Connection connection;

    public void testVirtualTopicCreation() throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection();
        }
        this.connection.start();
        ConsumerBean messageList1 = new ConsumerBean();
        ConsumerBean messageList2 = new ConsumerBean();
        messageList1.setVerbose(true);
        messageList2.setVerbose(true);
        Session session = this.connection.createSession(false, 1);
        Destination producerDestination = this.getProducerDestination();
        Destination destination1 = this.getConsumer1Dsetination();
        Destination destination2 = this.getConsumer2Dsetination();
        log.info("Sending to: " + producerDestination);
        log.info("Consuming from: " + destination1 + " and " + destination2);
        MessageConsumer c1 = session.createConsumer(destination1);
        MessageConsumer c2 = session.createConsumer(destination2);
        c1.setMessageListener(messageList1);
        c2.setMessageListener(messageList2);
        MessageProducer producer = session.createProducer(producerDestination);
        CompositeQueueTest.assertNotNull((Object)producer);
        int total = 10;
        for (int i = 0; i < total; ++i) {
            producer.send(session.createTextMessage("message: " + i));
        }
        messageList1.assertMessagesArrived(total);
        messageList2.assertMessagesArrived(total);
    }

    protected Destination getConsumer1Dsetination() {
        return new ActiveMQQueue("FOO");
    }

    protected Destination getConsumer2Dsetination() {
        return new ActiveMQTopic("BAR");
    }

    protected Destination getProducerDestination() {
        return new ActiveMQQueue("MY.QUEUE");
    }

    protected void tearDown() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
        super.tearDown();
    }

    protected BrokerService createBroker() throws Exception {
        XBeanBrokerFactory factory = new XBeanBrokerFactory();
        BrokerService answer = factory.createBroker(new URI(this.getBrokerConfigUri()));
        answer.setPersistent(false);
        return answer;
    }

    protected String getBrokerConfigUri() {
        return "org/apache/activemq/broker/virtual/composite-queue.xml";
    }
}

