/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.io.IOException;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.DataStructureTestSupport;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.util.ByteSequence;

public class MessageSendTest
extends DataStructureTestSupport {
    public static Test suite() {
        return MessageSendTest.suite(MessageSendTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MessageSendTest.suite());
    }

    public void initCombosForTestMessageSendMarshaling() {
        this.addCombinationValues("cacheEnabled", new Object[]{Boolean.TRUE, Boolean.FALSE});
    }

    public void testMessageSendMarshaling() throws IOException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setCommandId(1);
        message.setDestination(new ActiveMQQueue("queue"));
        message.setGroupID("group");
        message.setGroupSequence(4);
        message.setCorrelationId("correlation");
        message.setMessageId(new MessageId("c1:1:1", 1L));
        this.assertBeanMarshalls(message);
        this.assertBeanMarshalls(message);
    }

    public void xtestPerformance() throws IOException {
        ActiveMQMessage message = new ActiveMQMessage();
        message.setProducerId(new ProducerId(new SessionId(new ConnectionId(new ConnectionId("test")), 1L), 1L));
        message.setMessageId(new MessageId(message.getProducerId(), 1L));
        message.setCommandId(1);
        message.setGroupID("group");
        message.setGroupSequence(4);
        message.setCorrelationId("correlation");
        message.setContent(new ByteSequence(new byte[1024], 0, 1024));
        message.setTimestamp(System.currentTimeMillis());
        message.setDestination(new ActiveMQQueue("TEST"));
        int p = 1000000;
        long start = System.currentTimeMillis();
        for (int i = 0; i < p; ++i) {
            this.marshalAndUnmarshall(message, this.wireFormat);
        }
        long end = System.currentTimeMillis();
        log.info("marshaled/unmarshaled: " + p + " msgs at " + (float)p * 1000.0f / (float)(end - start) + " msgs/sec");
    }
}

