/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.command;

import java.util.Arrays;
import javax.transaction.xa.Xid;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.util.HexSupport;

public class XATransactionId
extends TransactionId
implements Xid {
    public static final byte DATA_STRUCTURE_TYPE = 112;
    private int formatId;
    private byte[] branchQualifier;
    private byte[] globalTransactionId;
    private transient int hash;

    public XATransactionId() {
    }

    public XATransactionId(Xid xid) {
        this.formatId = xid.getFormatId();
        this.globalTransactionId = xid.getGlobalTransactionId();
        this.branchQualifier = xid.getBranchQualifier();
    }

    public byte getDataStructureType() {
        return 112;
    }

    public String getTransactionKey() {
        return "XID:" + this.formatId + ":" + HexSupport.toHexFromBytes(this.globalTransactionId) + ":" + HexSupport.toHexFromBytes(this.branchQualifier);
    }

    public String toString() {
        return this.getTransactionKey();
    }

    public boolean isXATransaction() {
        return true;
    }

    public boolean isLocalTransaction() {
        return false;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public byte[] getGlobalTransactionId() {
        return this.globalTransactionId;
    }

    public byte[] getBranchQualifier() {
        return this.branchQualifier;
    }

    public void setBranchQualifier(byte[] branchQualifier) {
        this.branchQualifier = branchQualifier;
        this.hash = 0;
    }

    public void setFormatId(int formatId) {
        this.formatId = formatId;
        this.hash = 0;
    }

    public void setGlobalTransactionId(byte[] globalTransactionId) {
        this.globalTransactionId = globalTransactionId;
        this.hash = 0;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = this.formatId;
            this.hash = XATransactionId.hash(this.globalTransactionId, this.hash);
            this.hash = XATransactionId.hash(this.branchQualifier, this.hash);
            if (this.hash == 0) {
                this.hash = 0xACEACE;
            }
        }
        return this.hash;
    }

    private static int hash(byte[] bytes, int hash) {
        int size = bytes.length;
        for (int i = 0; i < size; ++i) {
            hash ^= bytes[i] << i % 4 * 8;
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != XATransactionId.class) {
            return false;
        }
        XATransactionId xid = (XATransactionId)o;
        return xid.formatId == this.formatId && Arrays.equals(xid.globalTransactionId, this.globalTransactionId) && Arrays.equals(xid.branchQualifier, this.branchQualifier);
    }
}

