/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console;

import [Ljava.lang.String;;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Main {
    public static final String TASK_DEFAULT_CLASS = "org.apache.activemq.console.command.ShellCommand";
    private File activeMQHome;
    private File activeMQBase;
    private ClassLoader classLoader;
    private List classpaths = new ArrayList(5);
    private List extensions = new ArrayList(5);
    private static boolean useDefExt = true;

    public static void main(String[] args) {
        Main app = new Main();
        LinkedList<String> tokens = new LinkedList<String>(Arrays.asList(args));
        app.parseExtensions(tokens);
        if (useDefExt && app.canUseExtdir()) {
            boolean baseIsHome = app.getActiveMQBase().equals(app.getActiveMQHome());
            app.addClassPath(new File(app.getActiveMQBase(), "conf"));
            if (!baseIsHome) {
                app.addExtensionDirectory(new File(app.getActiveMQBase(), "lib"));
            }
            app.addExtensionDirectory(new File(app.getActiveMQHome(), "lib"));
            if (!baseIsHome) {
                app.addExtensionDirectory(new File(new File(app.getActiveMQBase(), "lib"), "optional"));
            }
            app.addExtensionDirectory(new File(new File(app.getActiveMQHome(), "lib"), "optional"));
        }
        try {
            app.runTaskClass(tokens);
        }
        catch (ClassNotFoundException e) {
            System.out.println("Could not load class: " + e.getMessage());
            try {
                ClassLoader cl = app.getClassLoader();
                if (cl != null) {
                    System.out.println("Class loader setup: ");
                    Main.printClassLoaderTree(cl);
                }
            }
            catch (MalformedURLException e1) {}
        }
        catch (Throwable e) {
            System.out.println("Failed to execute main task. Reason: " + e);
        }
    }

    private static int printClassLoaderTree(ClassLoader cl) {
        int depth = 0;
        if (cl.getParent() != null) {
            depth = Main.printClassLoaderTree(cl.getParent()) + 1;
        }
        StringBuffer indent = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            indent.append("  ");
        }
        if (cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            System.out.println(indent + cl.getClass().getName() + " {");
            URL[] urls = ucl.getURLs();
            for (int i = 0; i < urls.length; ++i) {
                System.out.println(indent + "  " + urls[i]);
            }
            System.out.println(indent + "}");
        } else {
            System.out.println(indent + cl.getClass().getName());
        }
        return depth;
    }

    public void parseExtensions(List tokens) {
        if (tokens.isEmpty()) {
            return;
        }
        int count = tokens.size();
        int i = 0;
        while (i < count) {
            String token = (String)tokens.get(i);
            if (token.equals("--extdir")) {
                tokens.remove(i);
                if (i >= --count || ((String)tokens.get(i)).startsWith("-")) {
                    System.out.println("Extension directory not specified.");
                    System.out.println("Ignoring extension directory option.");
                    continue;
                }
                --count;
                File extDir = new File((String)tokens.remove(i));
                if (!this.canUseExtdir()) {
                    System.out.println("Extension directory feature not available due to the system classpath being able to load: org.apache.activemq.console.command.ShellCommand");
                    System.out.println("Ignoring extension directory option.");
                    continue;
                }
                if (!extDir.isDirectory()) {
                    System.out.println("Extension directory specified is not valid directory: " + extDir);
                    System.out.println("Ignoring extension directory option.");
                    continue;
                }
                this.addExtensionDirectory(extDir);
                continue;
            }
            if (token.equals("--noDefExt")) {
                --count;
                tokens.remove(i);
                useDefExt = false;
                continue;
            }
            ++i;
        }
    }

    public void runTaskClass(List tokens) throws Throwable {
        System.out.println("ACTIVEMQ_HOME: " + this.getActiveMQHome());
        System.out.println("ACTIVEMQ_BASE: " + this.getActiveMQBase());
        ClassLoader cl = this.getClassLoader();
        try {
            String[] args = tokens.toArray(new String[tokens.size()]);
            Class<?> task = cl.loadClass(TASK_DEFAULT_CLASS);
            Method runTask = task.getMethod("main", String;.class, InputStream.class, PrintStream.class);
            runTask.invoke(task.newInstance(), args, System.in, System.out);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public void addExtensionDirectory(File directory) {
        this.extensions.add(directory);
    }

    private void addClassPath(File file) {
        this.classpaths.add(file);
    }

    public boolean canUseExtdir() {
        try {
            Main.class.getClassLoader().loadClass(TASK_DEFAULT_CLASS);
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }

    public ClassLoader getClassLoader() throws MalformedURLException {
        if (this.classLoader == null) {
            this.classLoader = Main.class.getClassLoader();
            if (!this.extensions.isEmpty() || !this.classpaths.isEmpty()) {
                File dir;
                ArrayList<URL> urls = new ArrayList<URL>();
                Iterator iter = this.classpaths.iterator();
                while (iter.hasNext()) {
                    dir = (File)iter.next();
                    urls.add(dir.toURL());
                }
                iter = this.extensions.iterator();
                while (iter.hasNext()) {
                    File[] files;
                    dir = (File)iter.next();
                    if (!dir.isDirectory() || (files = dir.listFiles()) == null) continue;
                    Arrays.sort(files, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            File f1 = (File)o1;
                            File f2 = (File)o2;
                            return f1.getName().compareTo(f2.getName());
                        }
                    });
                    for (int j = 0; j < files.length; ++j) {
                        if (!files[j].getName().endsWith(".zip") && !files[j].getName().endsWith(".jar")) continue;
                        urls.add(files[j].toURL());
                    }
                }
                URL[] u = new URL[urls.size()];
                urls.toArray(u);
                this.classLoader = new URLClassLoader(u, this.classLoader);
            }
            Thread.currentThread().setContextClassLoader(this.classLoader);
        }
        return this.classLoader;
    }

    public void setActiveMQHome(File activeMQHome) {
        this.activeMQHome = activeMQHome;
    }

    public File getActiveMQHome() {
        if (this.activeMQHome == null) {
            URL url;
            if (System.getProperty("activemq.home") != null) {
                this.activeMQHome = new File(System.getProperty("activemq.home"));
            }
            if (this.activeMQHome == null && (url = Main.class.getClassLoader().getResource("org/apache/activemq/console/Main.class")) != null) {
                try {
                    JarURLConnection jarConnection = (JarURLConnection)url.openConnection();
                    url = jarConnection.getJarFileURL();
                    URI baseURI = new URI(url.toString()).resolve("..");
                    this.activeMQHome = new File(baseURI).getCanonicalFile();
                    System.setProperty("activemq.home", this.activeMQHome.getAbsolutePath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.activeMQHome == null) {
                this.activeMQHome = new File("../.");
                System.setProperty("activemq.home", this.activeMQHome.getAbsolutePath());
            }
        }
        return this.activeMQHome;
    }

    public File getActiveMQBase() {
        if (this.activeMQBase == null) {
            if (System.getProperty("activemq.base") != null) {
                this.activeMQBase = new File(System.getProperty("activemq.base"));
            }
            if (this.activeMQBase == null) {
                this.activeMQBase = this.getActiveMQHome();
                System.setProperty("activemq.base", this.activeMQBase.getAbsolutePath());
            }
        }
        return this.activeMQBase;
    }
}

