/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.activemq.console.command.AbstractJmxCommand;
import org.apache.activemq.console.formatter.GlobalWriter;
import org.apache.activemq.console.util.JmxMBeansUtil;

public class QueryCommand
extends AbstractJmxCommand {
    private static final Properties PREDEFINED_OBJNAME_QUERY = new Properties();
    private final List queryAddObjects = new ArrayList(10);
    private final List querySubObjects = new ArrayList(10);
    private final Set queryViews = new HashSet(10);
    protected String[] helpFile = new String[]{"Task Usage: Main query [query-options]", "Description: Display selected broker component's attributes and statistics.", "", "Query Options:", "    -Q<type>=<name>               Add to the search list the specific object type matched", "                                  by the defined object identifier.", "    -xQ<type>=<name>              Remove from the search list the specific object type", "                                  matched by the object identifier.", "    --objname <query>             Add to the search list objects matched by the query similar", "                                  to the JMX object name format.", "    --xobjname <query>            Remove from the search list objects matched by the query", "                                  similar to the JMX object name format.", "    --view <attr1>,<attr2>,...    Select the specific attribute of the object to view.", "                                  By default all attributes will be displayed.", "    --jmxurl <url>                Set the JMX URL to connect to.", "    --version                     Display the version information.", "    -h,-?,--help                  Display the query broker help information.", "", "Examples:", "    Main query", "        - Print all the attributes of all registered objects queues, topics, connections, etc).", "", "    Main query -QQueue=TEST.FOO", "        - Print all the attributes of the queue with destination name TEST.FOO.", "", "    Main query -QTopic=*", "        - Print all the attributes of all registered topics.", "", "    Main query --view EnqueueCount,DequeueCount", "        - Print the attributes EnqueueCount and DequeueCount of all registered objects.", "", "    Main -QTopic=* --view EnqueueCount,DequeueCount", "        - Print the attributes EnqueueCount and DequeueCount of all registered topics.", "", "    Main -QTopic=* -QQueue=* --view EnqueueCount,DequeueCount", "        - Print the attributes EnqueueCount and DequeueCount of all registered topics and", "          queues.", "", "    Main -QTopic=* -xQTopic=ActiveMQ.Advisory.*", "        - Print all attributes of all topics except those that has a name that begins", "          with \"ActiveMQ.Advisory\".", "", "    Main --objname Type=*Connect*,BrokerName=local* -xQNetworkConnector=*", "        - Print all attributes of all connectors, connections excluding network connectors", "          that belongs to the broker that begins with local.", "", "    Main -QQueue=* -xQQueue=????", "        - Print all attributes of all queues except those that are 4 letters long.", ""};

    protected void runTask(List tokens) throws Exception {
        try {
            List addMBeans = JmxMBeansUtil.queryMBeans(this.useJmxServiceUrl(), this.queryAddObjects, this.queryViews);
            if (this.querySubObjects.size() > 0) {
                List subMBeans = JmxMBeansUtil.queryMBeans(this.useJmxServiceUrl(), this.querySubObjects, this.queryViews);
                addMBeans.removeAll(subMBeans);
            }
            GlobalWriter.printMBean(JmxMBeansUtil.filterMBeansView(addMBeans, this.queryViews));
        }
        catch (Exception e) {
            GlobalWriter.printException(new RuntimeException("Failed to execute query task. Reason: " + e));
            throw new Exception(e);
        }
    }

    protected void handleOption(String token, List tokens) throws Exception {
        if (token.startsWith("-Q")) {
            String predefQuery;
            String key = token.substring(2);
            String value = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                value = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            if ((predefQuery = PREDEFINED_OBJNAME_QUERY.getProperty(key)) == null) {
                GlobalWriter.printException(new IllegalArgumentException("Unknown query object type: " + key));
                return;
            }
            String queryStr = JmxMBeansUtil.createQueryString(predefQuery, value);
            StringTokenizer queryTokens = new StringTokenizer(queryStr, ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("-xQ")) {
            String predefQuery;
            String key = token.substring(3);
            String value = "";
            int pos = key.indexOf("=");
            if (pos >= 0) {
                value = key.substring(pos + 1);
                key = key.substring(0, pos);
            }
            if ((predefQuery = PREDEFINED_OBJNAME_QUERY.getProperty(key)) == null) {
                GlobalWriter.printException(new IllegalArgumentException("Unknown query object type: " + key));
                return;
            }
            String queryStr = JmxMBeansUtil.createQueryString(predefQuery, value);
            StringTokenizer queryTokens = new StringTokenizer(queryStr, ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--objname")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("Object name query not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.queryAddObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--xobjname")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("Object name query not specified"));
                return;
            }
            StringTokenizer queryTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (queryTokens.hasMoreTokens()) {
                this.querySubObjects.add(queryTokens.nextToken());
            }
        } else if (token.startsWith("--view")) {
            if (tokens.isEmpty() || ((String)tokens.get(0)).startsWith("-")) {
                GlobalWriter.printException(new IllegalArgumentException("Attributes to view not specified"));
                return;
            }
            StringTokenizer viewTokens = new StringTokenizer((String)tokens.remove(0), ",");
            while (viewTokens.hasMoreElements()) {
                this.queryViews.add(viewTokens.nextElement());
            }
        } else {
            super.handleOption(token, tokens);
        }
    }

    protected void printHelp() {
        GlobalWriter.printHelp(this.helpFile);
    }

    static {
        PREDEFINED_OBJNAME_QUERY.setProperty("Broker", "Type=Broker,BrokerName=%1,*");
        PREDEFINED_OBJNAME_QUERY.setProperty("Connection", "Type=Connection,Connection=%1,*");
        PREDEFINED_OBJNAME_QUERY.setProperty("Connector", "Type=Connector,ConnectorName=%1,*");
        PREDEFINED_OBJNAME_QUERY.setProperty("NetworkConnector", "Type=NetworkConnector,BrokerName=%1,*");
        PREDEFINED_OBJNAME_QUERY.setProperty("Queue", "Type=Queue,Destination=%1,*");
        PREDEFINED_OBJNAME_QUERY.setProperty("Topic", "Type=Topic,Destination=%1,*");
    }
}

