/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMap;

public class DestinationMapTest
extends TestCase {
    protected DestinationMap map = new DestinationMap();
    protected ActiveMQDestination d1 = this.createDestination("TEST.D1");
    protected ActiveMQDestination d2 = this.createDestination("TEST.BAR.D2");
    protected ActiveMQDestination d3 = this.createDestination("TEST.BAR.D3");
    protected ActiveMQDestination compositeDestination1 = this.createDestination("TEST.D1,TEST.BAR.D2");
    protected ActiveMQDestination compositeDestination2 = this.createDestination("TEST.D1,TEST.BAR.D3");
    protected Object v1 = "value1";
    protected Object v2 = "value2";
    protected Object v3 = "value3";
    protected Object v4 = "value4";
    protected Object v5 = "value5";
    protected Object v6 = "value6";

    public void testCompositeDestinations() throws Exception {
        ActiveMQDestination d1 = this.createDestination("TEST.BAR.D2");
        ActiveMQDestination d2 = this.createDestination("TEST.BAR.D3");
        this.map.put(d1, d1);
        this.map.put(d2, d2);
        this.map.get(this.createDestination("TEST.BAR.D2,TEST.BAR.D3"));
    }

    public void testSimpleDestinations() throws Exception {
        this.map.put(this.d1, this.v1);
        this.map.put(this.d2, this.v2);
        this.map.put(this.d3, this.v3);
        this.assertMapValue(this.d1, this.v1);
        this.assertMapValue(this.d2, this.v2);
        this.assertMapValue(this.d3, this.v3);
    }

    public void testQueueAndTopicWithSameName() throws Exception {
        ActiveMQQueue q1 = new ActiveMQQueue("foo");
        ActiveMQTopic t1 = new ActiveMQTopic("foo");
        this.map.put(q1, this.v1);
        this.map.put(t1, this.v2);
        this.assertMapValue(q1, this.v1);
        this.assertMapValue(t1, this.v2);
    }

    public void testSimpleDestinationsWithMultipleValues() throws Exception {
        this.map.put(this.d1, this.v1);
        this.map.put(this.d2, this.v2);
        this.map.put(this.d2, this.v3);
        this.assertMapValue(this.d1, this.v1);
        this.assertMapValue("TEST.BAR.D2", this.v2, this.v3);
        this.assertMapValue(this.d3, null);
    }

    public void testSimpleAndCompositeDestinations() throws Exception {
        this.map.put(this.d1, this.v1);
        this.map.put(this.compositeDestination1, this.v2);
        this.map.put(this.compositeDestination2, this.v3);
        this.assertMapValue("TEST.D1", this.v1, this.v2, this.v3);
        this.assertMapValue(this.d2, this.v2);
        this.assertMapValue(this.d3, this.v3);
        this.assertMapValue(this.compositeDestination1.toString(), this.v1, this.v2, this.v3);
        this.assertMapValue(this.compositeDestination2.toString(), this.v1, this.v2, this.v3);
        this.map.remove(this.compositeDestination1, this.v2);
        this.map.remove(this.compositeDestination2, this.v3);
        this.assertMapValue("TEST.D1", this.v1);
    }

    public void testLookupOneStepWildcardDestinations() throws Exception {
        this.map.put(this.d1, this.v1);
        this.map.put(this.d2, this.v2);
        this.map.put(this.d3, this.v3);
        this.assertMapValue("TEST.D1", this.v1);
        this.assertMapValue("TEST.*", this.v1);
        this.assertMapValue("*.D1", this.v1);
        this.assertMapValue("*.*", this.v1);
        this.assertMapValue("TEST.BAR.D2", this.v2);
        this.assertMapValue("TEST.*.D2", this.v2);
        this.assertMapValue("*.BAR.D2", this.v2);
        this.assertMapValue("*.*.D2", this.v2);
        this.assertMapValue("TEST.BAR.D3", this.v3);
        this.assertMapValue("TEST.*.D3", this.v3);
        this.assertMapValue("*.BAR.D3", this.v3);
        this.assertMapValue("*.*.D3", this.v3);
        this.assertMapValue("TEST.BAR.D4", null);
        this.assertMapValue("TEST.BAR.*", this.v2, this.v3);
    }

    public void testLookupMultiStepWildcardDestinations() throws Exception {
        this.map.put(this.d1, this.v1);
        this.map.put(this.d2, this.v2);
        this.map.put(this.d3, this.v3);
        List<Object> allValues = Arrays.asList(this.v1, this.v2, this.v3);
        this.assertMapValue(">", allValues);
        this.assertMapValue("TEST.>", allValues);
        this.assertMapValue("*.>", allValues);
        this.assertMapValue("FOO.>", null);
    }

    public void testStoreWildcardWithOneStepPath() throws Exception {
        this.put("TEST.*", this.v1);
        this.put("TEST.D1", this.v2);
        this.put("TEST.BAR.*", this.v2);
        this.put("TEST.BAR.D3", this.v3);
        this.assertMapValue("FOO", null);
        this.assertMapValue("TEST.FOO", this.v1);
        this.assertMapValue("TEST.D1", this.v1, this.v2);
        this.assertMapValue("TEST.FOO.FOO", null);
        this.assertMapValue("TEST.BAR.FOO", this.v2);
        this.assertMapValue("TEST.BAR.D3", this.v2, this.v3);
        this.assertMapValue("TEST.*", this.v1, this.v2);
        this.assertMapValue("*.D1", this.v1, this.v2);
        this.assertMapValue("*.*", this.v1, this.v2);
        this.assertMapValue("TEST.*.*", this.v2, this.v3);
        this.assertMapValue("TEST.BAR.*", this.v2, this.v3);
        this.assertMapValue("*.*.*", this.v2, this.v3);
        this.assertMapValue("*.BAR.*", this.v2, this.v3);
        this.assertMapValue("*.BAR.D3", this.v2, this.v3);
        this.assertMapValue("*.*.D3", this.v2, this.v3);
    }

    public void testStoreWildcardInMiddleOfPath() throws Exception {
        this.put("TEST.*", this.v1);
        this.put("TEST.D1", this.v2);
        this.put("TEST.BAR.*", this.v2);
        this.put("TEST.XYZ.D3", this.v3);
        this.put("TEST.XYZ.D4", this.v4);
        this.put("TEST.BAR.D3", this.v5);
        this.put("TEST.*.D2", this.v6);
        this.assertMapValue("TEST.*.D3", this.v2, this.v3, this.v5);
        this.assertMapValue("TEST.*.D4", this.v2, this.v4);
        this.assertMapValue("TEST.*", this.v1, this.v2);
        this.assertMapValue("TEST.*.*", this.v2, this.v3, this.v4, this.v5, this.v6);
        this.assertMapValue("TEST.*.>", this.v1, this.v2, this.v3, this.v4, this.v5, this.v6);
        this.assertMapValue("TEST.>", this.v1, this.v2, this.v3, this.v4, this.v5, this.v6);
        this.assertMapValue("TEST.>.>", this.v1, this.v2, this.v3, this.v4, this.v5, this.v6);
        this.assertMapValue("*.*.D3", this.v2, this.v3, this.v5);
        this.assertMapValue("TEST.BAR.*", this.v2, this.v5, this.v6);
        this.assertMapValue("TEST.BAR.D2", this.v2, this.v6);
        this.assertMapValue("TEST.*.D2", this.v2, this.v6);
        this.assertMapValue("TEST.BAR.*", this.v2, this.v5, this.v6);
    }

    public void testAnyPathWildcardInMap() throws Exception {
        this.put("TEST.FOO.>", this.v1);
        this.assertMapValue("TEST.FOO.BAR.WHANOT.A.B.C", this.v1);
        this.assertMapValue("TEST.FOO.BAR.WHANOT", this.v1);
        this.assertMapValue("TEST.FOO.BAR", this.v1);
        this.assertMapValue("TEST.*.*", this.v1);
        this.assertMapValue("TEST.BAR", null);
        this.assertMapValue("TEST.FOO", this.v1);
    }

    public void testSimpleAddRemove() throws Exception {
        this.put("TEST.D1", this.v2);
        DestinationMapTest.assertEquals((String)"Root child count", (int)1, (int)this.map.getTopicRootChildCount());
        this.assertMapValue("TEST.D1", this.v2);
        this.remove("TEST.D1", this.v2);
        DestinationMapTest.assertEquals((String)"Root child count", (int)0, (int)this.map.getTopicRootChildCount());
        this.assertMapValue("TEST.D1", null);
    }

    public void testStoreAndLookupAllWildcards() throws Exception {
        this.loadSample2();
        this.assertSample2();
        this.remove("TEST.FOO", this.v1);
        this.assertMapValue("TEST.FOO", this.v2, this.v3, this.v4);
        this.assertMapValue("TEST.*", this.v2, this.v3, this.v4, this.v6);
        this.assertMapValue("*.*", this.v2, this.v3, this.v4, this.v6);
        this.remove("TEST.XYZ", this.v6);
        this.assertMapValue("TEST.*", this.v2, this.v3, this.v4);
        this.assertMapValue("*.*", this.v2, this.v3, this.v4);
        this.remove("TEST.*", this.v2);
        this.assertMapValue("TEST.*", this.v3, this.v4);
        this.assertMapValue("*.*", this.v3, this.v4);
        this.remove(">", this.v4);
        this.assertMapValue("TEST.*", this.v3);
        this.assertMapValue("*.*", this.v3);
        this.remove("TEST.>", this.v3);
        this.remove("TEST.FOO.BAR", this.v5);
        this.assertMapValue("FOO", null);
        this.assertMapValue("TEST.FOO", null);
        this.assertMapValue("TEST.D1", null);
        this.assertMapValue("TEST.FOO.FOO", null);
        this.assertMapValue("TEST.BAR.FOO", null);
        this.assertMapValue("TEST.FOO.BAR", null);
        this.assertMapValue("TEST.BAR.D3", null);
        this.assertMapValue("TEST.*", null);
        this.assertMapValue("*.*", null);
        this.assertMapValue("*.D1", null);
        this.assertMapValue("TEST.*.*", null);
        this.assertMapValue("TEST.BAR.*", null);
        this.loadSample2();
        this.assertSample2();
        this.remove(">", this.v4);
        this.remove("TEST.*", this.v2);
        this.assertMapValue("FOO", null);
        this.assertMapValue("TEST.FOO", this.v1, this.v3);
        this.assertMapValue("TEST.D1", this.v3);
        this.assertMapValue("TEST.FOO.FOO", this.v3);
        this.assertMapValue("TEST.BAR.FOO", this.v3);
        this.assertMapValue("TEST.FOO.BAR", this.v3, this.v5);
        this.assertMapValue("TEST.BAR.D3", this.v3);
        this.assertMapValue("TEST.*", this.v1, this.v3, this.v6);
        this.assertMapValue("*.*", this.v1, this.v3, this.v6);
        this.assertMapValue("*.D1", this.v3);
        this.assertMapValue("TEST.*.*", this.v3, this.v5);
        this.assertMapValue("TEST.BAR.*", this.v3);
    }

    public void testAddAndRemove() throws Exception {
        this.put("FOO.A", this.v1);
        this.assertMapValue("FOO.>", this.v1);
        this.put("FOO.B", this.v2);
        this.assertMapValue("FOO.>", this.v1, this.v2);
        Set set = this.map.removeAll(this.createDestination("FOO.A"));
        this.assertMapValue("FOO.>", this.v2);
    }

    protected void loadSample2() {
        this.put("TEST.FOO", this.v1);
        this.put("TEST.*", this.v2);
        this.put("TEST.>", this.v3);
        this.put(">", this.v4);
        this.put("TEST.FOO.BAR", this.v5);
        this.put("TEST.XYZ", this.v6);
    }

    protected void assertSample2() {
        this.assertMapValue("FOO", this.v4);
        this.assertMapValue("TEST.FOO", this.v1, this.v2, this.v3, this.v4);
        this.assertMapValue("TEST.D1", this.v2, this.v3, this.v4);
        this.assertMapValue("TEST.FOO.FOO", this.v3, this.v4);
        this.assertMapValue("TEST.BAR.FOO", this.v3, this.v4);
        this.assertMapValue("TEST.FOO.BAR", this.v3, this.v4, this.v5);
        this.assertMapValue("TEST.BAR.D3", this.v3, this.v4);
        this.assertMapValue("TEST.*", this.v1, this.v2, this.v3, this.v4, this.v6);
        this.assertMapValue("*.*", this.v1, this.v2, this.v3, this.v4, this.v6);
        this.assertMapValue("*.D1", this.v2, this.v3, this.v4);
        this.assertMapValue("TEST.*.*", this.v3, this.v4, this.v5);
        this.assertMapValue("TEST.BAR.*", this.v3, this.v4);
    }

    protected void put(String name, Object value) {
        this.map.put(this.createDestination(name), value);
    }

    protected void remove(String name, Object value) {
        ActiveMQDestination destination = this.createDestination(name);
        this.map.remove(destination, value);
    }

    protected void assertMapValue(String destinationName, Object expected) {
        ActiveMQDestination destination = this.createDestination(destinationName);
        this.assertMapValue(destination, expected);
    }

    protected void assertMapValue(String destinationName, Object expected1, Object expected2) {
        this.assertMapValue(destinationName, Arrays.asList(expected1, expected2));
    }

    protected void assertMapValue(String destinationName, Object expected1, Object expected2, Object expected3) {
        this.assertMapValue(destinationName, Arrays.asList(expected1, expected2, expected3));
    }

    protected void assertMapValue(String destinationName, Object expected1, Object expected2, Object expected3, Object expected4) {
        this.assertMapValue(destinationName, Arrays.asList(expected1, expected2, expected3, expected4));
    }

    protected void assertMapValue(String destinationName, Object expected1, Object expected2, Object expected3, Object expected4, Object expected5) {
        this.assertMapValue(destinationName, Arrays.asList(expected1, expected2, expected3, expected4, expected5));
    }

    protected void assertMapValue(String destinationName, Object expected1, Object expected2, Object expected3, Object expected4, Object expected5, Object expected6) {
        this.assertMapValue(destinationName, Arrays.asList(expected1, expected2, expected3, expected4, expected5, expected6));
    }

    protected void assertMapValue(ActiveMQDestination destination, Object expected) {
        ArrayList<Object> expectedList = null;
        if (expected == null) {
            expectedList = Collections.EMPTY_LIST;
        } else if (expected instanceof List) {
            expectedList = (List)expected;
        } else {
            expectedList = new ArrayList<Object>();
            expectedList.add(expected);
        }
        Collections.sort(expectedList);
        Set actualSet = this.map.get(destination);
        ArrayList actual = new ArrayList(actualSet);
        Collections.sort(actual);
        DestinationMapTest.assertEquals((String)("map value for destinationName:  " + destination), expectedList, actual);
    }

    protected ActiveMQDestination createDestination(String name) {
        return new ActiveMQTopic(name);
    }
}

