/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha;

import java.io.IOException;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;

public class VolumeTest
extends TestCase {
    protected Store store;
    protected String name;
    protected static final int NUMBER = 1;

    public void testListVolume() throws Exception {
        ListContainer container = this.store.getListContainer("volume");
        container.setMarshaller(Store.BytesMarshaller);
        byte[] data = new byte[10];
        for (int i = 0; i < 1; ++i) {
            container.add(data);
            if (i % 100000 != 0) continue;
            System.err.println("persisted " + i);
        }
        int count = 0;
        Iterator i = container.iterator();
        while (i.hasNext()) {
            VolumeTest.assertNotNull(i.next());
            if (++count % 100000 != 0) continue;
            System.err.println("retrived  " + count);
        }
        VolumeTest.assertEquals((String)"Different retrieved to stored", (int)1, (int)count);
    }

    protected Store getStore() throws IOException {
        return StoreFactory.open(this.name, "rw");
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/volume-container.db";
        StoreFactory.delete(this.name);
        this.store = StoreFactory.open(this.name, "rw");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
        }
        VolumeTest.assertTrue((boolean)StoreFactory.delete(this.name));
    }
}

