/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.kaha.impl.KahaStore;
import org.apache.activemq.kaha.impl.container.ContainerId;
import org.apache.activemq.kaha.impl.container.ListContainerImpl;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;

public class CachedListContainerImplTest
extends TestCase {
    protected String name;
    protected KahaStore store;
    protected int MAX_CACHE_SIZE = 10;

    protected KahaStore getStore() throws IOException {
        KahaStore store = new KahaStore(this.name, "rw");
        store.initialize();
        return store;
    }

    public void testAdds() throws Exception {
        int i;
        ListContainerImpl list = this.getStoreList("test");
        List data = this.getDataList(100);
        list.addAll((Collection)data);
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        List cached = this.getCachedList(this.MAX_CACHE_SIZE);
        for (i = 0; i < cached.size(); ++i) {
            list.add(i, cached.get(i));
        }
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        for (i = 0; i < cached.size(); ++i) {
            CachedListContainerImplTest.assertEquals(cached.get(i), list.getCacheList().get(i));
        }
    }

    public void testAddsIntoCacheSpace() throws Exception {
        int i;
        ListContainerImpl list = this.getStoreList("test");
        int initialDataSize = 50;
        List data = this.getDataList(initialDataSize);
        list.addAll((Collection)data);
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        List cached = this.getCachedList(this.MAX_CACHE_SIZE);
        for (i = this.MAX_CACHE_SIZE / 2; i < cached.size(); ++i) {
            list.add(i, cached.get(i));
        }
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        for (i = 0; i < this.MAX_CACHE_SIZE / 2; ++i) {
            CachedListContainerImplTest.assertEquals(data.get(i), list.getCacheList().get(i));
        }
        for (i = this.MAX_CACHE_SIZE / 2; i < this.MAX_CACHE_SIZE; ++i) {
            CachedListContainerImplTest.assertEquals(cached.get(i), list.getCacheList().get(i));
        }
    }

    public void testRemoves() throws Exception {
        int i;
        ListContainerImpl list = this.getStoreList("test");
        int initialDataSize = 10;
        List data = this.getDataList(initialDataSize);
        list.addAll((Collection)data);
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        List cached = this.getCachedList(this.MAX_CACHE_SIZE);
        list.addAll((Collection)cached);
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        for (i = 0; i < cached.size(); ++i) {
            CachedListContainerImplTest.assertNotSame(cached.get(i), list.getCacheList().get(i));
        }
        for (i = 0; i < initialDataSize; ++i) {
            list.remove(0);
        }
        CachedListContainerImplTest.assertEquals((int)0, (int)list.getCacheList().size());
        for (i = 0; i < this.MAX_CACHE_SIZE; ++i) {
            list.get(i);
        }
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        for (i = 0; i < cached.size(); ++i) {
            CachedListContainerImplTest.assertEquals(cached.get(i), list.getCacheList().get(i));
        }
    }

    public void testCacheSize() throws Exception {
        ListContainerImpl list = this.getStoreList("test");
        List data = this.getDataList(100);
        list.addAll((Collection)data);
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
    }

    public void testInserts() throws Exception {
        int i;
        ListContainerImpl list = this.getStoreList("test");
        List data = this.getDataList(100);
        list.addAll((Collection)data);
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        List cached = this.getCachedList(this.MAX_CACHE_SIZE);
        for (i = 0; i < cached.size(); ++i) {
            list.set(i, cached.get(i));
        }
        CachedListContainerImplTest.assertEquals((int)this.MAX_CACHE_SIZE, (int)list.getCacheList().size());
        for (i = 0; i < cached.size(); ++i) {
            CachedListContainerImplTest.assertEquals(cached.get(i), list.getCacheList().get(i));
        }
    }

    protected ListContainerImpl getStoreList(Object id) throws Exception {
        String containerName = "test";
        DataManager dm = this.store.getDataManager(containerName);
        IndexManager im = this.store.getIndexManager(dm, containerName);
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        IndexItem root = this.store.getListsContainer().addRoot(im, containerId);
        ListContainerImpl result = new ListContainerImpl(containerId, root, im, dm, "DiskIndex");
        result.expressDataInterest();
        result.setMaximumCacheSize(this.MAX_CACHE_SIZE);
        return result;
    }

    protected List getDataList(int num) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            result.add("data:" + i);
        }
        return result;
    }

    protected List getCachedList(int num) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            result.add("cached:" + i);
        }
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.name = System.getProperty("basedir", ".") + "/target/activemq-data/store-test.db";
        this.store = this.getStore();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
        boolean rc = StoreFactory.delete(this.name);
        CachedListContainerImplTest.assertTrue((boolean)rc);
    }
}

