/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileLock;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.IndexRootContainer;
import org.apache.activemq.kaha.impl.StoreLockedExcpetion;
import org.apache.activemq.kaha.impl.container.BaseContainerImpl;
import org.apache.activemq.kaha.impl.container.ContainerId;
import org.apache.activemq.kaha.impl.container.ListContainerImpl;
import org.apache.activemq.kaha.impl.container.MapContainerImpl;
import org.apache.activemq.kaha.impl.data.DataManager;
import org.apache.activemq.kaha.impl.data.RedoListener;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.apache.activemq.kaha.impl.index.RedoStoreIndexItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KahaStore
implements Store {
    private static final String DEFAULT_CONTAINER_NAME = "kaha";
    private static final String PROPERTY_PREFIX = "org.apache.activemq.kaha.Store";
    private static final boolean brokenFileLock = "true".equals(System.getProperty("org.apache.activemq.kaha.Store.broken", "false"));
    private static final boolean disableLocking = "true".equals(System.getProperty("org.apache.activemq.kaha.StoreDisableLocking", "false"));
    private static final String LOCKSET_MONITOR = "org.apache.activemq.kaha.Store.Lock.Monitor";
    private static final Log log = LogFactory.getLog(KahaStore.class);
    private File directory;
    private IndexRootContainer mapsContainer;
    private IndexRootContainer listsContainer;
    private Map lists = new ConcurrentHashMap();
    private Map maps = new ConcurrentHashMap();
    private Map dataManagers = new ConcurrentHashMap();
    private Map indexManagers = new ConcurrentHashMap();
    private IndexManager rootIndexManager;
    private boolean closed = false;
    private String mode;
    private boolean initialized;
    private boolean logIndexChanges = false;
    private long maxDataFileLength = DataManager.MAX_FILE_LENGTH;
    private FileLock lock;
    private String indexType = "DiskIndex";

    public KahaStore(String name, String mode) throws IOException {
        this.mode = mode;
        this.directory = new File(name);
        this.directory.mkdirs();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.initialized) {
                this.unlock();
                Iterator iter = this.indexManagers.values().iterator();
                while (iter.hasNext()) {
                    IndexManager im = (IndexManager)iter.next();
                    im.close();
                    iter.remove();
                }
                iter = this.dataManagers.values().iterator();
                while (iter.hasNext()) {
                    DataManager dm = (DataManager)iter.next();
                    dm.close();
                    iter.remove();
                }
            }
        }
    }

    public synchronized void force() throws IOException {
        if (this.initialized) {
            Iterator iter = this.indexManagers.values().iterator();
            while (iter.hasNext()) {
                IndexManager im = (IndexManager)iter.next();
                im.force();
            }
            iter = this.dataManagers.values().iterator();
            while (iter.hasNext()) {
                DataManager dm = (DataManager)iter.next();
                dm.force();
            }
        }
    }

    public synchronized void clear() throws IOException {
        BaseContainerImpl container;
        this.initialize();
        Iterator i = this.maps.values().iterator();
        while (i.hasNext()) {
            container = (BaseContainerImpl)i.next();
            container.clear();
        }
        i = this.lists.values().iterator();
        while (i.hasNext()) {
            container = (BaseContainerImpl)i.next();
            container.clear();
        }
    }

    public synchronized boolean delete() throws IOException {
        boolean result = true;
        if (this.initialized) {
            this.clear();
            Iterator iter = this.indexManagers.values().iterator();
            while (iter.hasNext()) {
                IndexManager im = (IndexManager)iter.next();
                result &= im.delete();
                iter.remove();
            }
            iter = this.dataManagers.values().iterator();
            while (iter.hasNext()) {
                DataManager dm = (DataManager)iter.next();
                result &= dm.delete();
                iter.remove();
            }
        }
        if (this.directory != null && this.directory.isDirectory()) {
            File[] files = this.directory.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    File file = files[i];
                    if (file.isDirectory()) continue;
                    result &= file.delete();
                }
            }
            log.info("Kaha Store deleted data directory " + this.directory);
        }
        this.initialized = false;
        return result;
    }

    public boolean doesMapContainerExist(Object id) throws IOException {
        return this.doesMapContainerExist(id, DEFAULT_CONTAINER_NAME);
    }

    public boolean doesMapContainerExist(Object id, String containerName) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        return this.maps.containsKey(containerId) || this.mapsContainer.doesRootExist(containerId);
    }

    public MapContainer getMapContainer(Object id) throws IOException {
        return this.getMapContainer(id, DEFAULT_CONTAINER_NAME);
    }

    public MapContainer getMapContainer(Object id, String containerName) throws IOException {
        return this.getMapContainer(id, containerName, this.indexType);
    }

    public synchronized MapContainer getMapContainer(Object id, String containerName, String indexType) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        MapContainerImpl result = (MapContainerImpl)this.maps.get(containerId);
        if (result == null) {
            DataManager dm = this.getDataManager(containerName);
            IndexManager im = this.getIndexManager(dm, containerName);
            IndexItem root = this.mapsContainer.getRoot(im, containerId);
            if (root == null) {
                root = this.mapsContainer.addRoot(im, containerId);
            }
            result = new MapContainerImpl(containerId, root, im, dm, indexType);
            this.maps.put(containerId, result);
        }
        return result;
    }

    public void deleteMapContainer(Object id) throws IOException {
        this.deleteMapContainer(id, DEFAULT_CONTAINER_NAME);
    }

    public void deleteMapContainer(Object id, String containerName) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        MapContainerImpl container = (MapContainerImpl)this.maps.remove(containerId);
        if (container != null) {
            container.clear();
            this.mapsContainer.removeRoot(container.getIndexManager(), containerId);
        }
    }

    public Set getMapContainerIds() throws IOException {
        this.initialize();
        HashSet<Object> set = new HashSet<Object>();
        Iterator i = this.mapsContainer.getKeys().iterator();
        while (i.hasNext()) {
            ContainerId id = (ContainerId)i.next();
            set.add(id.getKey());
        }
        return set;
    }

    public boolean doesListContainerExist(Object id) throws IOException {
        return this.doesListContainerExist(id, DEFAULT_CONTAINER_NAME);
    }

    public boolean doesListContainerExist(Object id, String containerName) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        return this.lists.containsKey(containerId) || this.listsContainer.doesRootExist(containerId);
    }

    public ListContainer getListContainer(Object id) throws IOException {
        return this.getListContainer(id, DEFAULT_CONTAINER_NAME);
    }

    public ListContainer getListContainer(Object id, String containerName) throws IOException {
        return this.getListContainer(id, containerName, this.indexType);
    }

    public synchronized ListContainer getListContainer(Object id, String containerName, String indexType) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        ListContainerImpl result = (ListContainerImpl)this.lists.get(containerId);
        if (result == null) {
            DataManager dm = this.getDataManager(containerName);
            IndexManager im = this.getIndexManager(dm, containerName);
            IndexItem root = this.listsContainer.getRoot(im, containerId);
            if (root == null) {
                root = this.listsContainer.addRoot(im, containerId);
            }
            result = new ListContainerImpl(containerId, root, im, dm, indexType);
            this.lists.put(containerId, result);
        }
        return result;
    }

    public void deleteListContainer(Object id) throws IOException {
        this.deleteListContainer(id, DEFAULT_CONTAINER_NAME);
    }

    public void deleteListContainer(Object id, String containerName) throws IOException {
        this.initialize();
        ContainerId containerId = new ContainerId();
        containerId.setKey(id);
        containerId.setDataContainerName(containerName);
        ListContainerImpl container = (ListContainerImpl)this.lists.remove(containerId);
        if (container != null) {
            this.listsContainer.removeRoot(container.getIndexManager(), containerId);
            container.clear();
        }
    }

    public Set getListContainerIds() throws IOException {
        this.initialize();
        HashSet<Object> set = new HashSet<Object>();
        Iterator i = this.listsContainer.getKeys().iterator();
        while (i.hasNext()) {
            ContainerId id = (ContainerId)i.next();
            set.add(id.getKey());
        }
        return set;
    }

    public IndexRootContainer getListsContainer() {
        return this.listsContainer;
    }

    public IndexRootContainer getMapsContainer() {
        return this.mapsContainer;
    }

    public DataManager getDataManager(String name) throws IOException {
        DataManager dm = (DataManager)this.dataManagers.get(name);
        if (dm == null) {
            dm = new DataManager(this.directory, name);
            dm.setMaxFileLength(this.maxDataFileLength);
            this.recover(dm);
            this.dataManagers.put(name, dm);
        }
        return dm;
    }

    public IndexManager getIndexManager(DataManager dm, String name) throws IOException {
        IndexManager im = (IndexManager)this.indexManagers.get(name);
        if (im == null) {
            im = new IndexManager(this.directory, name, this.mode, this.logIndexChanges ? dm : null);
            this.indexManagers.put(name, im);
        }
        return im;
    }

    private void recover(final DataManager dm) throws IOException {
        dm.recoverRedoItems(new RedoListener(){

            public void onRedoItem(StoreLocation item, Object o) throws Exception {
                RedoStoreIndexItem redo = (RedoStoreIndexItem)o;
                IndexManager im = KahaStore.this.getIndexManager(dm, dm.getName());
                im.redo(redo);
            }
        });
    }

    public boolean isLogIndexChanges() {
        return this.logIndexChanges;
    }

    public void setLogIndexChanges(boolean logIndexChanges) {
        this.logIndexChanges = logIndexChanges;
    }

    public long getMaxDataFileLength() {
        return this.maxDataFileLength;
    }

    public void setMaxDataFileLength(long maxDataFileLength) {
        this.maxDataFileLength = maxDataFileLength;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String type) {
        if (type == null || !type.equals("DiskIndex") && !type.equals("InMemoryIndex")) {
            throw new RuntimeException("Unknown IndexType: " + type);
        }
        this.indexType = type;
    }

    public synchronized void initialize() throws IOException {
        if (this.closed) {
            throw new IOException("Store has been closed.");
        }
        if (!this.initialized) {
            this.initialized = true;
            log.info("Kaha Store using data directory " + this.directory);
            DataManager defaultDM = this.getDataManager(DEFAULT_CONTAINER_NAME);
            this.rootIndexManager = this.getIndexManager(defaultDM, DEFAULT_CONTAINER_NAME);
            IndexItem mapRoot = new IndexItem();
            IndexItem listRoot = new IndexItem();
            if (this.rootIndexManager.isEmpty()) {
                mapRoot.setOffset(0L);
                this.rootIndexManager.storeIndex(mapRoot);
                listRoot.setOffset(51L);
                this.rootIndexManager.storeIndex(listRoot);
                this.rootIndexManager.setLength(102L);
            } else {
                mapRoot = this.rootIndexManager.getIndex(0L);
                listRoot = this.rootIndexManager.getIndex(51L);
            }
            this.lock();
            this.mapsContainer = new IndexRootContainer(mapRoot, this.rootIndexManager, defaultDM);
            this.listsContainer = new IndexRootContainer(listRoot, this.rootIndexManager, defaultDM);
            this.generateInterestInMapDataFiles();
            this.generateInterestInListDataFiles();
            Iterator i = this.dataManagers.values().iterator();
            while (i.hasNext()) {
                DataManager dm = (DataManager)i.next();
                dm.consolidateDataFiles();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lock() throws IOException {
        String string = LOCKSET_MONITOR;
        synchronized (LOCKSET_MONITOR) {
            if (!disableLocking && this.directory != null && this.lock == null) {
                String key = this.getPropertyKey();
                String property = System.getProperty(key);
                if (null == property) {
                    if (!brokenFileLock) {
                        this.lock = this.rootIndexManager.getLock();
                        if (this.lock == null) {
                            throw new StoreLockedExcpetion("Kaha Store " + this.directory.getName() + "  is already opened by another application");
                        }
                        System.setProperty(key, new Date().toString());
                    }
                } else {
                    throw new StoreLockedExcpetion("Kaha Store " + this.directory.getName() + " is already opened by this application.");
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock() throws IOException {
        String string = LOCKSET_MONITOR;
        synchronized (LOCKSET_MONITOR) {
            if (!disableLocking && null != this.directory && null != this.lock) {
                System.getProperties().remove(this.getPropertyKey());
                if (this.lock.isValid()) {
                    this.lock.release();
                }
                this.lock = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String getPropertyKey() throws IOException {
        return this.getClass().getName() + ".lock." + this.directory.getCanonicalPath();
    }

    private void generateInterestInListDataFiles() throws IOException {
        Iterator i = this.listsContainer.getKeys().iterator();
        while (i.hasNext()) {
            ContainerId id = (ContainerId)i.next();
            DataManager dm = this.getDataManager(id.getDataContainerName());
            IndexManager im = this.getIndexManager(dm, id.getDataContainerName());
            IndexItem theRoot = this.listsContainer.getRoot(im, id);
            long nextItem = theRoot.getNextItem();
            while (nextItem != -1L) {
                IndexItem item = im.getIndex(nextItem);
                item.setOffset(nextItem);
                dm.addInterestInFile(item.getKeyFile());
                dm.addInterestInFile(item.getValueFile());
                nextItem = item.getNextItem();
            }
        }
    }

    private void generateInterestInMapDataFiles() throws IOException {
        Iterator i = this.mapsContainer.getKeys().iterator();
        while (i.hasNext()) {
            ContainerId id = (ContainerId)i.next();
            DataManager dm = this.getDataManager(id.getDataContainerName());
            IndexManager im = this.getIndexManager(dm, id.getDataContainerName());
            IndexItem theRoot = this.mapsContainer.getRoot(im, id);
            long nextItem = theRoot.getNextItem();
            while (nextItem != -1L) {
                IndexItem item = im.getIndex(nextItem);
                item.setOffset(nextItem);
                dm.addInterestInFile(item.getKeyFile());
                dm.addInterestInFile(item.getValueFile());
                nextItem = item.getNextItem();
            }
        }
    }
}

