/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.io.IOException;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.IndexManager;

public class DiskIndexLinkedList
implements IndexLinkedList {
    protected IndexManager indexManager;
    protected transient IndexItem root;
    protected transient IndexItem last;
    protected transient int size = 0;

    public DiskIndexLinkedList(IndexManager im, IndexItem header) {
        this.indexManager = im;
        this.root = header;
    }

    public IndexItem getRoot() {
        return this.root;
    }

    void setRoot(IndexItem e) {
        this.root = e;
    }

    public IndexItem getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.getNextEntry(this.root);
    }

    public IndexItem getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.last;
    }

    public StoreEntry removeFirst() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.getNextEntry(this.root);
        this.remove(result);
        return result;
    }

    public Object removeLast() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.last;
        this.remove(this.last);
        return result;
    }

    public void addFirst(IndexItem item) {
        if (this.size == 0) {
            this.last = item;
        }
        ++this.size;
    }

    public void addLast(IndexItem item) {
        ++this.size;
        this.last = item;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(IndexItem item) {
        this.addLast(item);
        return true;
    }

    public void clear() {
        this.last = null;
        this.size = 0;
    }

    public IndexItem get(int index) {
        return this.entry(index);
    }

    public void add(int index, IndexItem element) {
        if (index == this.size - 1) {
            this.last = element;
        }
        ++this.size;
    }

    public Object remove(int index) {
        IndexItem e = this.entry(index);
        this.remove(e);
        return e;
    }

    private IndexItem entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        IndexItem e = this.root;
        for (int i = 0; i <= index; ++i) {
            e = this.getNextEntry(e);
        }
        if (e != null && this.last != null && this.last.equals(e)) {
            this.last = e;
        }
        return e;
    }

    public int indexOf(StoreEntry o) {
        int index = 0;
        if (this.size > 0) {
            IndexItem e = this.getNextEntry(this.root);
            while (e != null) {
                if (o.equals(e)) {
                    return index;
                }
                ++index;
                e = this.getNextEntry(e);
            }
        }
        return -1;
    }

    public IndexItem getNextEntry(IndexItem current) {
        IndexItem result = null;
        if (current != null && current.getNextItem() >= 0L) {
            try {
                result = this.indexManager.getIndex(current.getNextItem());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to get next index from " + this.indexManager + " for " + current, e);
            }
        }
        if (result != null && this.last != null && this.last.equals(result)) {
            result = this.last;
        }
        return result;
    }

    public IndexItem getPrevEntry(IndexItem current) {
        IndexItem result = null;
        if (current != null && current.getPreviousItem() >= 0L) {
            try {
                result = this.indexManager.getIndex(current.getPreviousItem());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to  get current index for " + current, e);
            }
        }
        if (result != null && this.root != null && this.root.equals(result)) {
            return this.root;
        }
        return result;
    }

    public StoreEntry getEntry(StoreEntry current) {
        IndexItem result = null;
        if (current != null && current.getOffset() >= 0L) {
            try {
                result = this.indexManager.getIndex(current.getOffset());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to index", e);
            }
        }
        if (result != null && this.root != null && this.root.equals(result)) {
            return this.root;
        }
        return result;
    }

    public StoreEntry refreshEntry(StoreEntry current) {
        IndexItem result = null;
        if (current != null && current.getOffset() >= 0L) {
            try {
                result = this.indexManager.refreshIndex((IndexItem)current);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to index", e);
            }
        }
        if (result != null && this.root != null && this.root.equals(result)) {
            return this.root;
        }
        return result;
    }

    public void remove(IndexItem e) {
        if (e == this.root || e.equals(this.root)) {
            return;
        }
        if (e == this.last || e.equals(this.last)) {
            this.last = this.size > 1 ? this.getPrevEntry(this.last) : null;
        }
        --this.size;
    }
}

