/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;
import org.apache.activemq.kaha.impl.index.VMIndexLinkedList;

public class VMIndexLinkedListTest
extends TestCase {
    static final int NUMBER = 10;
    private IndexItem root;
    private List testData = new ArrayList();
    private IndexLinkedList list;

    protected void setUp() throws Exception {
        super.setUp();
        for (int i = 0; i < 10; ++i) {
            this.testData.add(new IndexItem());
        }
        this.root = new IndexItem();
        this.list = new VMIndexLinkedList(this.root);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testData.clear();
        this.list = null;
    }

    public void testGetFirst() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.add((IndexItem)this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((this.list.getFirst() == this.testData.get(0) ? 1 : 0) != 0);
    }

    public void testGetLast() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.add((IndexItem)this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((this.list.getLast() == this.testData.get(this.testData.size() - 1) ? 1 : 0) != 0);
    }

    public void testRemoveFirst() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.add((IndexItem)this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((this.list.removeFirst() == this.testData.get(0) ? 1 : 0) != 0);
    }

    public void testRemoveLast() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.add((IndexItem)this.testData.get(i));
        }
        VMIndexLinkedListTest.assertTrue((this.list.removeLast() == this.testData.get(this.testData.size() - 1) ? 1 : 0) != 0);
    }

    public void testAddFirst() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.addFirst((IndexItem)this.testData.get(i));
        }
        int count = 0;
        for (int i = this.testData.size() - 1; i >= 0; --i) {
            VMIndexLinkedListTest.assertTrue((this.testData.get(i) == this.list.get(count++) ? 1 : 0) != 0);
        }
    }

    public void testAddLast() {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.addLast((IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((this.testData.get(i) == this.list.get(i) ? 1 : 0) != 0);
        }
    }

    public void testSize() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.addLast((IndexItem)this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == i + 1 ? 1 : 0) != 0);
        }
    }

    public void testIsEmpty() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.addLast((IndexItem)this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == i + 1 ? 1 : 0) != 0);
        }
        this.list.clear();
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testAddIndexItem() {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.add((IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((this.testData.get(i) == this.list.get(i) ? 1 : 0) != 0);
        }
    }

    public void testClear() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.addLast((IndexItem)this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == i + 1 ? 1 : 0) != 0);
        }
        this.list.clear();
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testAddIntIndexItem() {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((this.testData.get(i) == this.list.get(i) ? 1 : 0) != 0);
        }
    }

    public void testRemoveInt() {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.remove(0);
        }
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.remove(this.list.size() - 1);
        }
        VMIndexLinkedListTest.assertTrue((boolean)this.list.isEmpty());
    }

    public void testIndexOf() {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            VMIndexLinkedListTest.assertTrue((this.list.indexOf((StoreEntry)this.testData.get(i)) == i ? 1 : 0) != 0);
        }
    }

    public void testGetNextEntry() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        IndexItem next = this.list.getFirst();
        int count = 0;
        while (next != null) {
            VMIndexLinkedListTest.assertTrue((next == this.testData.get(count++) ? 1 : 0) != 0);
            next = this.list.getNextEntry(next);
            VMIndexLinkedListTest.assertTrue((next != this.root ? 1 : 0) != 0);
        }
    }

    public void testGetPrevEntry() {
        for (int i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        IndexItem next = this.list.getLast();
        int count = this.testData.size() - 1;
        while (next != null) {
            VMIndexLinkedListTest.assertTrue((next == this.testData.get(count--) ? 1 : 0) != 0);
            next = this.list.getPrevEntry(next);
            VMIndexLinkedListTest.assertTrue((next != this.root ? 1 : 0) != 0);
        }
    }

    public void testRemoveIndexItem() {
        int i;
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.add(i, (IndexItem)this.testData.get(i));
        }
        for (i = 0; i < this.testData.size(); ++i) {
            this.list.remove((IndexItem)this.testData.get(i));
            VMIndexLinkedListTest.assertTrue((this.list.size() == this.testData.size() - i - 1 ? 1 : 0) != 0);
        }
    }
}

