/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.filter.DestinationFilter;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.DemandSubscription;
import org.apache.activemq.transport.Transport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConduitBridge
extends DemandForwardingBridge {
    private static final Log log = LogFactory.getLog(ConduitBridge.class);

    public ConduitBridge(Transport localBroker, Transport remoteBroker) {
        super(localBroker, remoteBroker);
    }

    protected DemandSubscription createDemandSubscription(ConsumerInfo info) throws IOException {
        if (this.addToAlreadyInterestedConsumers(info)) {
            return null;
        }
        return this.doCreateDemandSubscription(info);
    }

    protected boolean addToAlreadyInterestedConsumers(ConsumerInfo info) {
        if (info.getSelector() != null) {
            return false;
        }
        boolean matched = false;
        DestinationFilter filter = DestinationFilter.parseFilter(info.getDestination());
        Iterator i = this.subscriptionMapByLocalId.values().iterator();
        while (i.hasNext()) {
            DemandSubscription ds = (DemandSubscription)i.next();
            if (!filter.matches(ds.getLocalInfo().getDestination())) continue;
            ds.add(info.getConsumerId());
            matched = true;
        }
        return matched;
    }

    protected void removeDemandSubscription(ConsumerId id) throws IOException {
        DemandSubscription ds;
        ArrayList<DemandSubscription> tmpList = new ArrayList<DemandSubscription>();
        Iterator i = this.subscriptionMapByLocalId.values().iterator();
        while (i.hasNext()) {
            ds = (DemandSubscription)i.next();
            ds.remove(id);
            if (!ds.isEmpty()) continue;
            tmpList.add(ds);
        }
        i = tmpList.iterator();
        while (i.hasNext()) {
            ds = (DemandSubscription)i.next();
            this.subscriptionMapByLocalId.remove(ds.getRemoteInfo().getConsumerId());
            this.removeSubscription(ds);
            if (!log.isTraceEnabled()) continue;
            log.trace("removing sub on " + this.localBroker + " from " + this.remoteBrokerName + " :  " + ds.getRemoteInfo());
        }
    }
}

