/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.network.DemandForwardingBridge;
import org.apache.activemq.network.NetworkTestSupport;

public class DemandForwardingBridgeTest
extends NetworkTestSupport {
    public ActiveMQDestination destination;
    public byte destinationType;
    public int deliveryMode;
    private DemandForwardingBridge bridge;

    public void initCombosForTestSendThenAddConsumer() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1)});
    }

    public void testSendThenAddConsumer() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send(connectionInfo1);
        connection1.send(sessionInfo1);
        connection1.send(producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send(connectionInfo2);
        connection2.send(sessionInfo2);
        connection1.send(this.createMessage(producerInfo, this.destination, this.deliveryMode));
        ConsumerInfo consumerInfo1 = this.createConsumerInfo(sessionInfo1, this.destination);
        connection1.send(consumerInfo1);
        Message m = this.receiveMessage(connection1);
        DemandForwardingBridgeTest.assertNotNull((Object)m);
        connection1.send(consumerInfo1.createRemoveCommand());
        ConsumerInfo consumerInfo2 = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send(consumerInfo2);
        m = this.receiveMessage(connection2);
        DemandForwardingBridgeTest.assertNotNull((Object)m);
    }

    public void initCombosForTestAddConsumerThenSend() {
        this.addCombinationValues("deliveryMode", new Object[]{new Integer(1), new Integer(2)});
        this.addCombinationValues("destinationType", new Object[]{new Byte(1), new Byte(2)});
    }

    public void testAddConsumerThenSend() throws Exception {
        StubConnection connection1 = this.createConnection();
        ConnectionInfo connectionInfo1 = this.createConnectionInfo();
        SessionInfo sessionInfo1 = this.createSessionInfo(connectionInfo1);
        ProducerInfo producerInfo = this.createProducerInfo(sessionInfo1);
        connection1.send(connectionInfo1);
        connection1.send(sessionInfo1);
        connection1.send(producerInfo);
        this.destination = this.createDestinationInfo(connection1, connectionInfo1, this.destinationType);
        StubConnection connection2 = this.createRemoteConnection();
        ConnectionInfo connectionInfo2 = this.createConnectionInfo();
        SessionInfo sessionInfo2 = this.createSessionInfo(connectionInfo2);
        connection2.send(connectionInfo2);
        connection2.send(sessionInfo2);
        ConsumerInfo consumerInfo = this.createConsumerInfo(sessionInfo2, this.destination);
        connection2.send(consumerInfo);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        connection1.send(this.createMessage(producerInfo, this.destination, this.deliveryMode));
        Message m = this.receiveMessage(connection2);
        DemandForwardingBridgeTest.assertNotNull((Object)m);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bridge = new DemandForwardingBridge(this.createTransport(), this.createRemoteTransport());
        this.bridge.setLocalBrokerName("local");
        this.bridge.setDispatchAsync(false);
        this.bridge.start();
    }

    protected void tearDown() throws Exception {
        this.bridge.stop();
        super.tearDown();
    }

    public static Test suite() {
        return DemandForwardingBridgeTest.suite(DemandForwardingBridgeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DemandForwardingBridgeTest.suite());
    }
}

