/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.command.BrokerId;
import org.apache.activemq.command.BrokerInfo;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.ExceptionResponse;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.network.Bridge;
import org.apache.activemq.transport.DefaultTransportListener;
import org.apache.activemq.transport.FutureResponse;
import org.apache.activemq.transport.ResponseCallback;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.util.ServiceSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ForwardingBridge
implements Bridge {
    private static final Log log = LogFactory.getLog(ForwardingBridge.class);
    private final Transport localBroker;
    private final Transport remoteBroker;
    IdGenerator idGenerator = new IdGenerator();
    ConnectionInfo connectionInfo;
    SessionInfo sessionInfo;
    ProducerInfo producerInfo;
    ConsumerInfo queueConsumerInfo;
    ConsumerInfo topicConsumerInfo;
    private String clientId;
    private int prefetchSize = 1000;
    private boolean dispatchAsync;
    private String destinationFilter = ">";
    private int queueDispatched;
    private int topicDispatched;
    BrokerId localBrokerId;
    BrokerId remoteBrokerId;

    public ForwardingBridge(Transport localBroker, Transport remoteBroker) {
        this.localBroker = localBroker;
        this.remoteBroker = remoteBroker;
    }

    public void start() throws Exception {
        log.info("Starting a network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
        this.localBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                ForwardingBridge.this.serviceLocalCommand(command);
            }

            public void onException(IOException error) {
                ForwardingBridge.this.serviceLocalException(error);
            }
        });
        this.remoteBroker.setTransportListener(new DefaultTransportListener(){

            public void onCommand(Object o) {
                Command command = (Command)o;
                ForwardingBridge.this.serviceRemoteCommand(command);
            }

            public void onException(IOException error) {
                ForwardingBridge.this.serviceRemoteException(error);
            }
        });
        this.localBroker.start();
        this.remoteBroker.start();
    }

    protected void triggerStartBridge() throws IOException {
        Thread thead = new Thread(){

            public void run() {
                try {
                    ForwardingBridge.this.startBridge();
                }
                catch (IOException e) {
                    log.error("Failed to start network bridge: " + e, e);
                }
            }
        };
        thead.start();
    }

    private void startBridge() throws IOException {
        this.connectionInfo = new ConnectionInfo();
        this.connectionInfo.setConnectionId(new ConnectionId(this.idGenerator.generateId()));
        this.connectionInfo.setClientId(this.clientId);
        this.localBroker.oneway(this.connectionInfo);
        this.remoteBroker.oneway(this.connectionInfo);
        this.sessionInfo = new SessionInfo(this.connectionInfo, 1L);
        this.localBroker.oneway(this.sessionInfo);
        this.remoteBroker.oneway(this.sessionInfo);
        this.queueConsumerInfo = new ConsumerInfo(this.sessionInfo, 1L);
        this.queueConsumerInfo.setDispatchAsync(this.dispatchAsync);
        this.queueConsumerInfo.setDestination(new ActiveMQQueue(this.destinationFilter));
        this.queueConsumerInfo.setPrefetchSize(this.prefetchSize);
        this.queueConsumerInfo.setPriority((byte)-5);
        this.localBroker.oneway(this.queueConsumerInfo);
        this.producerInfo = new ProducerInfo(this.sessionInfo, 1L);
        this.producerInfo.setResponseRequired(false);
        this.remoteBroker.oneway(this.producerInfo);
        if (this.connectionInfo.getClientId() != null) {
            this.topicConsumerInfo = new ConsumerInfo(this.sessionInfo, 2L);
            this.topicConsumerInfo.setDispatchAsync(this.dispatchAsync);
            this.topicConsumerInfo.setSubscriptionName("topic-bridge");
            this.topicConsumerInfo.setRetroactive(true);
            this.topicConsumerInfo.setDestination(new ActiveMQTopic(this.destinationFilter));
            this.topicConsumerInfo.setPrefetchSize(this.prefetchSize);
            this.topicConsumerInfo.setPriority((byte)-5);
            this.localBroker.oneway(this.topicConsumerInfo);
        }
        log.info("Network connection between " + this.localBroker + " and " + this.remoteBroker + " has been established.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        try {
            if (this.connectionInfo != null) {
                this.localBroker.request(this.connectionInfo.createRemoveCommand());
                this.remoteBroker.request(this.connectionInfo.createRemoveCommand());
            }
            this.localBroker.setTransportListener(null);
            this.remoteBroker.setTransportListener(null);
            this.localBroker.oneway(new ShutdownInfo());
            this.remoteBroker.oneway(new ShutdownInfo());
        }
        finally {
            ServiceStopper ss = new ServiceStopper();
            ss.stop(this.localBroker);
            ss.stop(this.remoteBroker);
            ss.throwFirstException();
        }
    }

    protected void serviceRemoteException(IOException error) {
        log.info("Unexpected remote exception: " + error);
        log.debug("Exception trace: ", error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceRemoteCommand(Command command) {
        block9: {
            try {
                if (command.isBrokerInfo()) {
                    ForwardingBridge forwardingBridge = this;
                    synchronized (forwardingBridge) {
                        this.remoteBrokerId = ((BrokerInfo)command).getBrokerId();
                        if (this.localBrokerId != null) {
                            if (this.localBrokerId.equals(this.remoteBrokerId)) {
                                log.info("Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block9;
                    }
                }
                log.warn("Unexpected remote command: " + command);
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    protected void serviceLocalException(Throwable error) {
        log.info("Unexpected local exception: " + error);
        log.debug("Exception trace: ", error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serviceLocalCommand(Command command) {
        block13: {
            try {
                if (command.isMessageDispatch()) {
                    final MessageDispatch md = (MessageDispatch)command;
                    Message message = md.getMessage();
                    message.setProducerId(this.producerInfo.getProducerId());
                    if (message.getOriginalTransactionId() == null) {
                        message.setOriginalTransactionId(message.getTransactionId());
                    }
                    message.setTransactionId(null);
                    message.evictMarshlledForm();
                    if (!message.isResponseRequired()) {
                        this.remoteBroker.oneway(message);
                        this.localBroker.oneway(new MessageAck(md, 2, 1));
                    } else {
                        ResponseCallback callback = new ResponseCallback(){

                            public void onCompletion(FutureResponse future) {
                                try {
                                    Response response = future.getResult();
                                    if (response.isException()) {
                                        ExceptionResponse er = (ExceptionResponse)response;
                                        ForwardingBridge.this.serviceLocalException(er.getException());
                                    } else {
                                        ForwardingBridge.this.localBroker.oneway(new MessageAck(md, 2, 1));
                                    }
                                }
                                catch (IOException e) {
                                    ForwardingBridge.this.serviceLocalException(e);
                                }
                            }
                        };
                        this.remoteBroker.asyncRequest(message, callback);
                    }
                    break block13;
                }
                if (command.isBrokerInfo()) {
                    ForwardingBridge md = this;
                    synchronized (md) {
                        this.localBrokerId = ((BrokerInfo)command).getBrokerId();
                        if (this.remoteBrokerId != null) {
                            if (this.remoteBrokerId.equals(this.localBrokerId)) {
                                log.info("Disconnecting loop back connection.");
                                ServiceSupport.dispose(this);
                            } else {
                                this.triggerStartBridge();
                            }
                        }
                        break block13;
                    }
                }
                log.debug("Unexpected local command: " + command);
            }
            catch (IOException e) {
                this.serviceLocalException(e);
            }
        }
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public boolean isDispatchAsync() {
        return this.dispatchAsync;
    }

    public void setDispatchAsync(boolean dispatchAsync) {
        this.dispatchAsync = dispatchAsync;
    }

    public String getDestinationFilter() {
        return this.destinationFilter;
    }

    public void setDestinationFilter(String destinationFilter) {
        this.destinationFilter = destinationFilter;
    }
}

