/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerRegistry;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerTestSupport;
import org.apache.activemq.broker.StubConnection;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;

public class NetworkTestSupport
extends BrokerTestSupport {
    protected ArrayList connections = new ArrayList();
    protected TransportConnector connector;
    protected PersistenceAdapter remotePersistenceAdapter;
    protected BrokerService remoteBroker;
    protected UsageManager remoteMemoryManager;
    protected TransportConnector remoteConnector;

    protected void setUp() throws Exception {
        super.setUp();
        this.connector = this.createConnector();
        this.connector.start();
        this.remotePersistenceAdapter = this.createRemotePersistenceAdapter(true);
        this.remotePersistenceAdapter.start();
        this.remoteBroker = this.createRemoteBroker(this.remotePersistenceAdapter);
        this.remoteBroker.start();
        BrokerRegistry.getInstance().bind("remotehost", this.remoteBroker);
        this.remoteConnector = this.createRemoteConnector();
        this.remoteConnector.start();
    }

    protected TransportConnector createRemoteConnector() throws Exception, IOException, URISyntaxException {
        return new TransportConnector(this.remoteBroker.getBroker(), TransportFactory.bind(this.broker.getBrokerName(), new URI(this.getRemoteURI())));
    }

    protected TransportConnector createConnector() throws Exception, IOException, URISyntaxException {
        return new TransportConnector(this.broker.getBroker(), TransportFactory.bind(this.broker.getBrokerName(), new URI(this.getLocalURI())));
    }

    protected String getRemoteURI() {
        return "vm://remotehost";
    }

    protected String getLocalURI() {
        return "vm://localhost";
    }

    protected PersistenceAdapter createRemotePersistenceAdapter(boolean clean) throws Exception {
        if (this.remotePersistenceAdapter == null || clean) {
            this.remotePersistenceAdapter = new MemoryPersistenceAdapter();
        }
        return this.remotePersistenceAdapter;
    }

    protected BrokerService createBroker() throws Exception {
        return BrokerFactory.createBroker(new URI("broker:()/localhost?persistent=false&useJmx=false"));
    }

    protected BrokerService createRemoteBroker(PersistenceAdapter persistenceAdapter) throws Exception {
        BrokerService answer = new BrokerService();
        answer.setUseJmx(false);
        answer.setPersistenceAdapter(persistenceAdapter);
        return answer;
    }

    protected StubConnection createConnection() throws Exception {
        Transport transport = TransportFactory.connect(this.connector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected StubConnection createRemoteConnection() throws Exception {
        Transport transport = TransportFactory.connect(this.remoteConnector.getServer().getConnectURI());
        StubConnection connection = new StubConnection(transport);
        this.connections.add(connection);
        return connection;
    }

    protected Transport createTransport() throws Exception {
        Transport transport = TransportFactory.connect(this.connector.getServer().getConnectURI());
        return transport;
    }

    protected Transport createRemoteTransport() throws Exception {
        Transport transport = TransportFactory.connect(this.remoteConnector.getServer().getConnectURI());
        return transport;
    }

    protected void restartRemoteBroker() throws Exception {
        BrokerRegistry.getInstance().unbind("remotehost");
        this.remoteConnector.stop();
        this.remoteBroker.stop();
        this.remotePersistenceAdapter.stop();
        this.remotePersistenceAdapter = this.createRemotePersistenceAdapter(false);
        this.remotePersistenceAdapter.start();
        this.remoteBroker = this.createRemoteBroker(this.remotePersistenceAdapter);
        this.remoteBroker.start();
        String brokerId = this.remoteBroker.getBrokerName();
        this.remoteConnector = new TransportConnector(this.broker.getBroker(), TransportFactory.bind(brokerId, new URI(this.getRemoteURI())));
        this.remoteConnector.start();
        BrokerRegistry.getInstance().bind("remotehost", this.remoteBroker);
    }

    protected void tearDown() throws Exception {
        Iterator iter = this.connections.iterator();
        while (iter.hasNext()) {
            StubConnection connection = (StubConnection)iter.next();
            connection.stop();
            iter.remove();
        }
        BrokerRegistry.getInstance().unbind("remotehost");
        this.remoteConnector.stop();
        this.connector.stop();
        this.remoteBroker.stop();
        this.remotePersistenceAdapter.stop();
        super.tearDown();
    }
}

