/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activemq.broker.BrokerFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.network.NetworkReconnectTest;

public class SSHTunnelNetworkReconnectTest
extends NetworkReconnectTest {
    ArrayList processes = new ArrayList();

    protected BrokerService createFirstBroker() throws Exception {
        return BrokerFactory.createBroker(new URI("xbean:org/apache/activemq/network/ssh-reconnect-broker1.xml"));
    }

    protected BrokerService createSecondBroker() throws Exception {
        return BrokerFactory.createBroker(new URI("xbean:org/apache/activemq/network/ssh-reconnect-broker2.xml"));
    }

    protected void setUp() throws Exception {
        this.startProcess("ssh -Nn -L60006:localhost:61616 localhost");
        this.startProcess("ssh -Nn -L60007:localhost:61617 localhost");
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        Iterator iter = this.processes.iterator();
        while (iter.hasNext()) {
            Process p = (Process)iter.next();
            p.destroy();
        }
    }

    private void startProcess(String command) throws IOException {
        final Process process = Runtime.getRuntime().exec(command);
        this.processes.add(process);
        new Thread("stdout: " + command){

            public void run() {
                try {
                    int c;
                    InputStream is = process.getInputStream();
                    while ((c = is.read()) >= 0) {
                        System.out.write(c);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
        new Thread("stderr: " + command){

            public void run() {
                try {
                    int c;
                    InputStream is = process.getErrorStream();
                    while ((c = is.read()) >= 0) {
                        System.err.write(c);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }.start();
    }
}

