/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueRequestor;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class QueueBridgeTest
extends TestCase
implements MessageListener {
    protected static final Log log = LogFactory.getLog(QueueBridgeTest.class);
    protected static final int MESSAGE_COUNT = 10;
    protected AbstractApplicationContext context;
    protected QueueConnection localConnection;
    protected QueueConnection remoteConnection;
    protected QueueRequestor requestor;
    protected QueueSession requestServerSession;
    protected MessageConsumer requestServerConsumer;
    protected MessageProducer requestServerProducer;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = this.createApplicationContext();
        this.createConnections();
        this.requestServerSession = this.localConnection.createQueueSession(false, 1);
        Queue theQueue = this.requestServerSession.createQueue(this.getClass().getName());
        this.requestServerConsumer = this.requestServerSession.createConsumer(theQueue);
        this.requestServerConsumer.setMessageListener(this);
        this.requestServerProducer = this.requestServerSession.createProducer(null);
        QueueSession session = this.remoteConnection.createQueueSession(false, 1);
        this.requestor = new QueueRequestor(session, theQueue);
    }

    protected void createConnections() throws JMSException {
        ActiveMQConnectionFactory fac = (ActiveMQConnectionFactory)this.context.getBean("localFactory");
        this.localConnection = fac.createQueueConnection();
        this.localConnection.start();
        fac = (ActiveMQConnectionFactory)this.context.getBean("remoteFactory");
        this.remoteConnection = fac.createQueueConnection();
        this.remoteConnection.start();
    }

    protected AbstractApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/activemq/network/jms/queue-config.xml");
    }

    protected void tearDown() throws Exception {
        this.localConnection.close();
        super.tearDown();
    }

    public void testQueueRequestorOverBridge() throws JMSException {
        for (int i = 0; i < 10; ++i) {
            TextMessage msg = this.requestServerSession.createTextMessage("test msg: " + i);
            TextMessage result = (TextMessage)this.requestor.request(msg);
            QueueBridgeTest.assertNotNull((Object)result);
            log.info(result.getText());
        }
    }

    public void onMessage(Message msg) {
        try {
            TextMessage textMsg = (TextMessage)msg;
            String payload = "REPLY: " + textMsg.getText();
            Destination replyTo = msg.getJMSReplyTo();
            textMsg.clearBody();
            textMsg.setText(payload);
            this.requestServerProducer.send(replyTo, textMsg);
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
    }
}

