/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MapMessage;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TopicSubscriber;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;

public class InactiveQueueTest
extends TestCase {
    private static final int MESSAGE_COUNT = 0;
    private static final String DEFAULT_PASSWORD = "";
    private static final String USERNAME = "testuser";
    private static final String CLIENTID = "mytestclient";
    private static final String QUEUE_NAME = "testevent";
    private static final int deliveryMode = 2;
    private static final int deliveryPriority = 4;
    private Connection connection = null;
    private MessageProducer publisher = null;
    private TopicSubscriber subscriber = null;
    private Destination destination = null;
    private Session session = null;
    ActiveMQConnectionFactory connectionFactory = null;
    BrokerService broker;

    protected void setUp() throws Exception {
        super.setUp();
        this.broker = new BrokerService();
        this.broker.addConnector("tcp://localhost:61616");
        this.broker.start();
        this.connectionFactory = new ActiveMQConnectionFactory("tcp://localhost:61616");
        this.connectionFactory.setUseAsyncSend(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.broker.stop();
    }

    public void testNoSubscribers() throws Exception {
        int loop;
        this.connection = this.connectionFactory.createConnection(USERNAME, DEFAULT_PASSWORD);
        InactiveQueueTest.assertNotNull((Object)this.connection);
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        InactiveQueueTest.assertNotNull((Object)this.session);
        this.destination = this.session.createQueue(QUEUE_NAME);
        InactiveQueueTest.assertNotNull((Object)this.destination);
        this.publisher = this.session.createProducer(this.destination);
        InactiveQueueTest.assertNotNull((Object)this.publisher);
        MapMessage msg = this.session.createMapMessage();
        InactiveQueueTest.assertNotNull((Object)msg);
        msg.setString("key1", "value1");
        for (loop = 0; loop < 0; ++loop) {
            msg.setInt("key2", loop);
            this.publisher.send(msg, 2, 4, 0L);
            if (loop % 500 != 0) continue;
            System.out.println("Sent " + loop + " messages");
        }
        Thread.sleep(1000000L);
        InactiveQueueTest.assertEquals((int)loop, (int)0);
        this.publisher.close();
        this.session.close();
        this.connection.stop();
        this.connection.stop();
    }
}

