/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.activemq.perf.PerfRate;

public class PerfConsumer
implements MessageListener {
    protected Connection connection;
    protected MessageConsumer consumer;
    protected PerfRate rate = new PerfRate();

    public PerfConsumer(ConnectionFactory fac, Destination dest, String consumerName) throws JMSException {
        this.connection = fac.createConnection();
        this.connection.setClientID(consumerName);
        Session s = this.connection.createSession(false, 1);
        this.consumer = dest instanceof Topic && consumerName != null && consumerName.length() > 0 ? s.createDurableSubscriber((Topic)dest, consumerName) : s.createConsumer(dest);
        this.consumer.setMessageListener(this);
    }

    public PerfConsumer(ConnectionFactory fac, Destination dest) throws JMSException {
        this(fac, dest, null);
    }

    public void start() throws JMSException {
        this.connection.start();
        this.rate.getRate();
    }

    public void stop() throws JMSException {
        this.connection.stop();
    }

    public void shutDown() throws JMSException {
        this.connection.close();
    }

    public PerfRate getRate() {
        return this.rate;
    }

    public void onMessage(Message msg) {
        this.rate.increment();
    }
}

