/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.perf;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.perf.PerfConsumer;
import org.apache.activemq.perf.SimpleTopicTest;
import org.apache.activemq.perf.SlowConsumer;
import org.apache.activemq.xbean.BrokerFactoryBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class SlowConsumerTopicTest
extends SimpleTopicTest {
    protected PerfConsumer[] slowConsumers;
    protected int NUMBER_OF_SLOW_CONSUMERS = 1;

    protected void setUp() throws Exception {
        super.setUp();
        this.slowConsumers = new SlowConsumer[this.NUMBER_OF_SLOW_CONSUMERS];
        for (int i = 0; i < this.NUMBER_OF_SLOW_CONSUMERS; ++i) {
            this.consumers[i] = this.createSlowConsumer(this.factory, this.destination, i);
            this.consumers[i].start();
        }
    }

    protected PerfConsumer createSlowConsumer(ConnectionFactory fac, Destination dest, int number) throws JMSException {
        return new SlowConsumer(fac, dest);
    }

    protected BrokerService createBroker() throws Exception {
        ClassPathResource resource = new ClassPathResource("org/apache/activemq/perf/slowConsumerBroker.xml");
        BrokerFactoryBean factory = new BrokerFactoryBean((Resource)resource);
        factory.afterPropertiesSet();
        BrokerService broker = factory.getBroker();
        broker.start();
        return broker;
    }
}

