/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.LDAPAuthorizationMap;
import org.apache.directory.server.core.configuration.StartupConfiguration;
import org.apache.directory.server.core.jndi.CoreContextFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class LDAPAuthorizationMapTest
extends TestCase {
    private HashMap options;
    private LDAPAuthorizationMap authMap;

    protected void setUp() throws Exception {
        super.setUp();
        this.startLdapServer();
        this.authMap = new LDAPAuthorizationMap();
    }

    protected void startLdapServer() throws Exception {
        ClassPathXmlApplicationContext factory = new ClassPathXmlApplicationContext("org/apache/activemq/security/ldap-spring.xml");
        StartupConfiguration cfg = (StartupConfiguration)factory.getBean("configuration");
        Properties env = (Properties)factory.getBean("environment");
        env.setProperty("java.naming.provider.url", "");
        env.setProperty("java.naming.factory.initial", CoreContextFactory.class.getName());
        env.putAll((Map<?, ?>)cfg.toJndiEnvironment());
        new InitialDirContext(env);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testOpen() throws Exception {
        DirContext ctx = this.authMap.open();
        HashSet<String> set = new HashSet<String>();
        NamingEnumeration<NameClassPair> list = ctx.list("ou=destinations,o=ActiveMQ,dc=example,dc=com");
        while (list.hasMore()) {
            NameClassPair ncp = list.next();
            set.add(ncp.getName());
        }
        LDAPAuthorizationMapTest.assertTrue((boolean)set.contains("ou=topics"));
        LDAPAuthorizationMapTest.assertTrue((boolean)set.contains("ou=queues"));
    }

    public void testGetAdminACLs() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1");
        Set aclsq1 = this.authMap.getAdminACLs(q1);
        LDAPAuthorizationMapTest.assertEquals((int)1, (int)aclsq1.size());
        LDAPAuthorizationMapTest.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role1")));
        ActiveMQTopic t1 = new ActiveMQTopic("topic1");
        Set aclst1 = this.authMap.getAdminACLs(t1);
        LDAPAuthorizationMapTest.assertEquals((int)1, (int)aclst1.size());
        LDAPAuthorizationMapTest.assertTrue((boolean)aclst1.contains(new GroupPrincipal("role1")));
    }

    public void testGetReadACLs() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1");
        Set aclsq1 = this.authMap.getReadACLs(q1);
        LDAPAuthorizationMapTest.assertEquals((int)1, (int)aclsq1.size());
        LDAPAuthorizationMapTest.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role1")));
        ActiveMQTopic t1 = new ActiveMQTopic("topic1");
        Set aclst1 = this.authMap.getReadACLs(t1);
        LDAPAuthorizationMapTest.assertEquals((int)1, (int)aclst1.size());
        LDAPAuthorizationMapTest.assertTrue((boolean)aclst1.contains(new GroupPrincipal("role2")));
    }

    public void testGetWriteACLs() {
        ActiveMQQueue q1 = new ActiveMQQueue("queue1");
        Set aclsq1 = this.authMap.getWriteACLs(q1);
        LDAPAuthorizationMapTest.assertEquals((int)2, (int)aclsq1.size());
        LDAPAuthorizationMapTest.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role1")));
        LDAPAuthorizationMapTest.assertTrue((boolean)aclsq1.contains(new GroupPrincipal("role2")));
        ActiveMQTopic t1 = new ActiveMQTopic("topic1");
        Set aclst1 = this.authMap.getWriteACLs(t1);
        LDAPAuthorizationMapTest.assertEquals((int)1, (int)aclst1.size());
        LDAPAuthorizationMapTest.assertTrue((boolean)aclst1.contains(new GroupPrincipal("role3")));
    }
}

