/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.Test;
import junit.textui.TestRunner;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerPlugin;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.security.AuthorizationMap;
import org.apache.activemq.security.AuthorizationPlugin;
import org.apache.activemq.security.JaasAuthenticationPlugin;
import org.apache.activemq.security.SecurityTestSupport;
import org.apache.activemq.security.SimpleAuthenticationBroker;
import org.apache.activemq.security.SimpleAuthorizationMap;

public class SimpleSecurityBrokerSystemTest
extends SecurityTestSupport {
    static final GroupPrincipal guests;
    static final GroupPrincipal users;
    static final GroupPrincipal admins;
    public BrokerPlugin authorizationPlugin;
    public BrokerPlugin authenticationPlugin;

    public static Test suite() {
        return SimpleSecurityBrokerSystemTest.suite(SimpleSecurityBrokerSystemTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SimpleSecurityBrokerSystemTest.suite());
    }

    public static AuthorizationMap createAuthorizationMap() {
        DestinationMap readAccess = new DestinationMap();
        readAccess.put(new ActiveMQQueue(">"), admins);
        readAccess.put(new ActiveMQQueue("USERS.>"), users);
        readAccess.put(new ActiveMQQueue("GUEST.>"), guests);
        readAccess.put(new ActiveMQTopic(">"), admins);
        readAccess.put(new ActiveMQTopic("USERS.>"), users);
        readAccess.put(new ActiveMQTopic("GUEST.>"), guests);
        DestinationMap writeAccess = new DestinationMap();
        writeAccess.put(new ActiveMQQueue(">"), admins);
        writeAccess.put(new ActiveMQQueue("USERS.>"), users);
        writeAccess.put(new ActiveMQQueue("GUEST.>"), users);
        writeAccess.put(new ActiveMQQueue("GUEST.>"), guests);
        writeAccess.put(new ActiveMQTopic(">"), admins);
        writeAccess.put(new ActiveMQTopic("USERS.>"), users);
        writeAccess.put(new ActiveMQTopic("GUEST.>"), users);
        writeAccess.put(new ActiveMQTopic("GUEST.>"), guests);
        readAccess.put(new ActiveMQTopic("ActiveMQ.Advisory.>"), guests);
        readAccess.put(new ActiveMQTopic("ActiveMQ.Advisory.>"), users);
        writeAccess.put(new ActiveMQTopic("ActiveMQ.Advisory.>"), guests);
        writeAccess.put(new ActiveMQTopic("ActiveMQ.Advisory.>"), users);
        DestinationMap adminAccess = new DestinationMap();
        adminAccess.put(new ActiveMQTopic(">"), admins);
        adminAccess.put(new ActiveMQTopic(">"), users);
        adminAccess.put(new ActiveMQTopic(">"), guests);
        adminAccess.put(new ActiveMQQueue(">"), admins);
        adminAccess.put(new ActiveMQQueue(">"), users);
        adminAccess.put(new ActiveMQQueue(">"), guests);
        return new SimpleAuthorizationMap(writeAccess, readAccess, adminAccess);
    }

    public void initCombos() {
        this.addCombinationValues("authorizationPlugin", new Object[]{new AuthorizationPlugin(SimpleSecurityBrokerSystemTest.createAuthorizationMap())});
        this.addCombinationValues("authenticationPlugin", new Object[]{new SimpleAuthenticationFactory(), new JaasAuthenticationPlugin()});
    }

    protected BrokerService createBroker() throws Exception {
        BrokerService broker = super.createBroker();
        broker.setPlugins(new BrokerPlugin[]{this.authorizationPlugin, this.authenticationPlugin});
        broker.setPersistent(false);
        return broker;
    }

    static {
        URL resource;
        guests = new GroupPrincipal("guests");
        users = new GroupPrincipal("users");
        admins = new GroupPrincipal("admins");
        String path = System.getProperty("java.security.auth.login.config");
        if (path == null && (resource = SimpleSecurityBrokerSystemTest.class.getClassLoader().getResource("login.config")) != null) {
            path = resource.getFile();
            System.setProperty("java.security.auth.login.config", path);
        }
        log.info("Path to login config: " + path);
    }

    class SimpleAuthenticationFactory
    implements BrokerPlugin {
        SimpleAuthenticationFactory() {
        }

        public Broker installPlugin(Broker broker) {
            HashMap<String, String> u = new HashMap<String, String>();
            u.put("system", "manager");
            u.put("user", "password");
            u.put("guest", "password");
            HashMap<String, HashSet<Object>> groups = new HashMap<String, HashSet<Object>>();
            groups.put("system", new HashSet<Object>(Arrays.asList(admins, users)));
            groups.put("user", new HashSet<Object>(Arrays.asList(users)));
            groups.put("guest", new HashSet<Object>(Arrays.asList(guests)));
            return new SimpleAuthenticationBroker(broker, u, groups);
        }

        public String toString() {
            return "SimpleAuthenticationBroker";
        }
    }
}

