/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.activemq.jaas.GroupPrincipal;
import org.apache.activemq.jaas.UserPrincipal;

public class StubLoginModule
implements LoginModule {
    public static final String ALLOW_LOGIN_PROPERTY = "org.apache.activemq.jaas.stubproperties.allow_login";
    public static final String USERS_PROPERTY = "org.apache.activemq.jaas.stubproperties.users";
    public static final String GROUPS_PROPERTY = "org.apache.activemq.jaas.stubproperties.groups";
    private Subject subject = null;
    private String[] userNames = null;
    private String[] groupNames = null;
    private boolean allowLogin = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String allowLoginString = (String)options.get(ALLOW_LOGIN_PROPERTY);
        String usersString = (String)options.get(USERS_PROPERTY);
        String groupsString = (String)options.get(GROUPS_PROPERTY);
        this.subject = subject;
        this.allowLogin = Boolean.parseBoolean(allowLoginString);
        this.userNames = usersString.split(",");
        this.groupNames = groupsString.split(",");
    }

    public boolean login() throws LoginException {
        if (!this.allowLogin) {
            throw new FailedLoginException("Login was not allowed (as specified in configuration).");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        int i;
        if (!this.allowLogin) {
            throw new FailedLoginException("Login was not allowed (as specified in configuration).");
        }
        for (i = 0; i < this.userNames.length; ++i) {
            if (this.userNames[i].length() <= 0) continue;
            this.subject.getPrincipals().add((Principal)new UserPrincipal(this.userNames[i]));
        }
        for (i = 0; i < this.groupNames.length; ++i) {
            if (this.groupNames[i].length() <= 0) continue;
            this.subject.getPrincipals().add((Principal)new GroupPrincipal(this.groupNames[i]));
        }
        return true;
    }

    public boolean abort() throws LoginException {
        return true;
    }

    public boolean logout() throws LoginException {
        this.subject.getPrincipals().clear();
        return true;
    }
}

