/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Message;
import javax.jms.MessageListener;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsumerBean
extends Assert
implements MessageListener {
    private static final Log log = LogFactory.getLog(ConsumerBean.class);
    private List messages = new ArrayList();
    private Object semaphore;
    private boolean verbose;

    public ConsumerBean() {
        this(new Object());
    }

    public ConsumerBean(Object semaphore) {
        this.semaphore = semaphore;
    }

    public synchronized List flushMessages() {
        ArrayList answer = new ArrayList(this.messages);
        this.messages.clear();
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onMessage(Message message) {
        this.messages.add(message);
        if (this.verbose) {
            log.info("Received: " + message);
        }
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessageToArrive() {
        long start;
        block5: {
            log.info("Waiting for message to arrive");
            start = System.currentTimeMillis();
            try {
                if (!this.hasReceivedMessage()) break block5;
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(4000L);
                }
            }
            catch (InterruptedException e) {
                log.info("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        log.info("End of wait for " + end + " millis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForMessagesToArrive(int messageCount) {
        log.info("Waiting for message to arrive");
        long start = System.currentTimeMillis();
        for (int i = 0; i < 10; ++i) {
            try {
                if (this.hasReceivedMessages(messageCount)) break;
                Object object = this.semaphore;
                synchronized (object) {
                    this.semaphore.wait(1000L);
                    continue;
                }
            }
            catch (InterruptedException e) {
                log.info("Caught: " + e);
            }
        }
        long end = System.currentTimeMillis() - start;
        log.info("End of wait for " + end + " millis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assertMessagesArrived(int total) {
        this.waitForMessagesToArrive(total);
        ConsumerBean consumerBean = this;
        synchronized (consumerBean) {
            int count = this.messages.size();
            ConsumerBean.assertEquals((String)"Messages received", (int)total, (int)count);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean hasReceivedMessage() {
        return this.messages.isEmpty();
    }

    protected synchronized boolean hasReceivedMessages(int messageCount) {
        return this.messages.size() >= messageCount;
    }
}

