/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.spring;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class SpringProducer {
    private static final Log log = LogFactory.getLog(SpringProducer.class);
    private JmsTemplate template;
    private Destination destination;
    private int messageCount = 10;

    public void start() throws JMSException {
        for (int i = 0; i < this.messageCount; ++i) {
            final String text = "Text for message: " + i;
            this.template.send(this.destination, new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    log.info("Sending message: " + text);
                    TextMessage message = session.createTextMessage(text);
                    message.setStringProperty("next", "foo");
                    return message;
                }
            });
        }
    }

    public void stop() throws JMSException {
    }

    public JmsTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JmsTemplate template) {
        this.template = template;
    }

    public int getMessageCount() {
        return this.messageCount;
    }

    public void setMessageCount(int messageCount) {
        this.messageCount = messageCount;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public void setDestination(Destination destination) {
        this.destination = destination;
    }
}

