/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadaptor;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.activemq.kaha.ListContainer;
import org.apache.activemq.kaha.MapContainer;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreFactory;
import org.apache.activemq.kaha.StringMarshaller;
import org.apache.activemq.memory.UsageManager;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.kahadaptor.CommandMarshaller;
import org.apache.activemq.store.kahadaptor.KahaMessageStore;
import org.apache.activemq.store.kahadaptor.KahaTopicMessageStore;
import org.apache.activemq.store.kahadaptor.KahaTransactionStore;
import org.apache.activemq.store.kahadaptor.TopicSubAckMarshaller;
import org.apache.activemq.store.kahadaptor.TransactionMarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class KahaPersistenceAdapter
implements PersistenceAdapter {
    private static final Log log = LogFactory.getLog(KahaPersistenceAdapter.class);
    static final String PREPARED_TRANSACTIONS_NAME = "PreparedTransactions";
    KahaTransactionStore transactionStore;
    ConcurrentHashMap topics = new ConcurrentHashMap();
    ConcurrentHashMap queues = new ConcurrentHashMap();
    ConcurrentHashMap messageStores = new ConcurrentHashMap();
    private boolean useExternalMessageReferences;
    private OpenWireFormat wireFormat = new OpenWireFormat();
    private long maxDataFileLength = 0x2000000L;
    private String indexType = "DiskIndex";
    private File dir;
    private Store theStore;

    public KahaPersistenceAdapter(File dir) throws IOException {
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.dir = dir;
    }

    public Set getDestinations() {
        HashSet rc = new HashSet();
        try {
            Store store = this.getStore();
            Iterator i = store.getMapContainerIds().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (!(obj instanceof ActiveMQDestination)) continue;
                rc.add(obj);
            }
        }
        catch (IOException e) {
            log.error("Failed to get destinations ", e);
        }
        return rc;
    }

    public synchronized MessageStore createQueueMessageStore(ActiveMQQueue destination) throws IOException {
        MessageStore rc = (MessageStore)this.queues.get(destination);
        if (rc == null) {
            rc = new KahaMessageStore(this.getMapContainer(destination, "queue-data"), destination);
            this.messageStores.put(destination, rc);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.queues.put(destination, rc);
        }
        return rc;
    }

    public synchronized TopicMessageStore createTopicMessageStore(ActiveMQTopic destination) throws IOException {
        TopicMessageStore rc = (TopicMessageStore)this.topics.get(destination);
        if (rc == null) {
            Store store = this.getStore();
            ListContainer messageContainer = this.getListContainer(destination, "topic-data");
            MapContainer subsContainer = this.getMapContainer(destination.toString() + "-Subscriptions", "topic-subs");
            ListContainer ackContainer = store.getListContainer(destination.toString(), "topic-acks");
            ackContainer.setMarshaller(new TopicSubAckMarshaller());
            rc = new KahaTopicMessageStore(store, messageContainer, ackContainer, subsContainer, destination);
            this.messageStores.put(destination, rc);
            if (this.transactionStore != null) {
                rc = this.transactionStore.proxy(rc);
            }
            this.topics.put(destination, rc);
        }
        return rc;
    }

    protected MessageStore retrieveMessageStore(Object id) {
        MessageStore result = (MessageStore)this.messageStores.get(id);
        return result;
    }

    public TransactionStore createTransactionStore() throws IOException {
        if (this.transactionStore == null) {
            Store store = this.getStore();
            MapContainer container = store.getMapContainer(PREPARED_TRANSACTIONS_NAME, "transactions");
            container.setKeyMarshaller(new CommandMarshaller(this.wireFormat));
            container.setValueMarshaller(new TransactionMarshaller(this.wireFormat));
            container.load();
            this.transactionStore = new KahaTransactionStore(this, container);
        }
        return this.transactionStore;
    }

    public void beginTransaction(ConnectionContext context) {
    }

    public void commitTransaction(ConnectionContext context) throws IOException {
        if (this.theStore != null) {
            this.theStore.force();
        }
    }

    public void rollbackTransaction(ConnectionContext context) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        if (this.theStore != null) {
            this.theStore.close();
        }
    }

    public long getLastMessageBrokerSequenceId() throws IOException {
        return 0L;
    }

    public void deleteAllMessages() throws IOException {
        if (this.theStore != null) {
            this.theStore.delete();
        }
    }

    public boolean isUseExternalMessageReferences() {
        return this.useExternalMessageReferences;
    }

    public void setUseExternalMessageReferences(boolean useExternalMessageReferences) {
        this.useExternalMessageReferences = useExternalMessageReferences;
    }

    protected MapContainer getMapContainer(Object id, String containerName) throws IOException {
        Store store = this.getStore();
        MapContainer container = store.getMapContainer(id, containerName);
        container.setKeyMarshaller(new StringMarshaller());
        if (this.useExternalMessageReferences) {
            container.setValueMarshaller(new StringMarshaller());
        } else {
            container.setValueMarshaller(new CommandMarshaller(this.wireFormat));
        }
        container.load();
        return container;
    }

    protected ListContainer getListContainer(Object id, String containerName) throws IOException {
        Store store = this.getStore();
        ListContainer container = store.getListContainer(id, containerName);
        if (this.useExternalMessageReferences) {
            container.setMarshaller(new StringMarshaller());
        } else {
            container.setMarshaller(new CommandMarshaller(this.wireFormat));
        }
        container.load();
        return container;
    }

    public void setUsageManager(UsageManager usageManager) {
    }

    public long getMaxDataFileLength() {
        return this.maxDataFileLength;
    }

    public void setMaxDataFileLength(long maxDataFileLength) {
        this.maxDataFileLength = maxDataFileLength;
    }

    public String getIndexType() {
        return this.indexType;
    }

    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    protected synchronized Store getStore() throws IOException {
        if (this.theStore == null) {
            String name = this.dir.getAbsolutePath() + File.separator + "kaha.db";
            this.theStore = StoreFactory.open(name, "rw");
            this.theStore.setMaxDataFileLength(this.maxDataFileLength);
            this.theStore.setIndexType(this.indexType);
        }
        return this.theStore;
    }
}

