/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.rapid;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.activeio.journal.RecordLocation;
import org.apache.activemq.command.JournalTopicAck;
import org.apache.activemq.command.JournalTransaction;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.XATransactionId;
import org.apache.activemq.store.TransactionRecoveryListener;
import org.apache.activemq.store.TransactionStore;
import org.apache.activemq.store.rapid.RapidMessageStore;
import org.apache.activemq.store.rapid.RapidPersistenceAdapter;
import org.apache.activemq.store.rapid.RapidTopicMessageStore;

public class RapidTransactionStore
implements TransactionStore {
    private final RapidPersistenceAdapter peristenceAdapter;
    ConcurrentHashMap inflightTransactions = new ConcurrentHashMap();
    ConcurrentHashMap preparedTransactions = new ConcurrentHashMap();
    private boolean doingRecover;

    public RapidTransactionStore(RapidPersistenceAdapter adapter) {
        this.peristenceAdapter = adapter;
    }

    public void prepare(TransactionId txid) throws IOException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        this.peristenceAdapter.writeCommand(new JournalTransaction(1, txid, false), true);
        this.preparedTransactions.put(txid, tx);
    }

    public void replayPrepare(TransactionId txid) throws IOException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        this.preparedTransactions.put(txid, tx);
    }

    public Tx getTx(Object txid, RecordLocation location) {
        Tx tx = (Tx)this.inflightTransactions.get(txid);
        if (tx == null) {
            tx = new Tx(location);
            this.inflightTransactions.put(txid, tx);
        }
        return tx;
    }

    public void commit(TransactionId txid, boolean wasPrepared) throws IOException {
        Tx tx = wasPrepared ? (Tx)this.preparedTransactions.remove(txid) : (Tx)this.inflightTransactions.remove(txid);
        if (tx == null) {
            return;
        }
        if (txid.isXATransaction()) {
            this.peristenceAdapter.writeCommand(new JournalTransaction(2, txid, wasPrepared), true);
        } else {
            this.peristenceAdapter.writeCommand(new JournalTransaction(4, txid, wasPrepared), true);
        }
    }

    public Tx replayCommit(TransactionId txid, boolean wasPrepared) throws IOException {
        if (wasPrepared) {
            return (Tx)this.preparedTransactions.remove(txid);
        }
        return (Tx)this.inflightTransactions.remove(txid);
    }

    public void rollback(TransactionId txid) throws IOException {
        Tx tx = (Tx)this.inflightTransactions.remove(txid);
        if (tx != null) {
            tx = (Tx)this.preparedTransactions.remove(txid);
        }
        if (tx != null) {
            if (txid.isXATransaction()) {
                this.peristenceAdapter.writeCommand(new JournalTransaction(3, txid, false), true);
            } else {
                this.peristenceAdapter.writeCommand(new JournalTransaction(5, txid, false), true);
            }
        }
    }

    public void replayRollback(TransactionId txid) throws IOException {
        if (this.inflightTransactions.remove(txid) != null) {
            this.preparedTransactions.remove(txid);
        }
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void recover(TransactionRecoveryListener listener) throws IOException {
        this.inflightTransactions.clear();
        this.doingRecover = true;
        try {
            Iterator iter = this.preparedTransactions.keySet().iterator();
            while (iter.hasNext()) {
                Object txid = iter.next();
                Tx tx = (Tx)this.preparedTransactions.get(txid);
                listener.recover((XATransactionId)txid, tx.getMessages(), tx.getAcks());
            }
        }
        finally {
            this.doingRecover = false;
        }
    }

    void addMessage(RapidMessageStore store, Message message, RecordLocation location) throws IOException {
        Tx tx = this.getTx(message.getTransactionId(), location);
        tx.add(store, message, location);
    }

    public void removeMessage(RapidMessageStore store, MessageAck ack, RecordLocation location) throws IOException {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack, location);
    }

    public void acknowledge(RapidTopicMessageStore store, JournalTopicAck ack, RecordLocation location) {
        Tx tx = this.getTx(ack.getTransactionId(), location);
        tx.add(store, ack, location);
    }

    public RecordLocation checkpoint() throws IOException {
        RecordLocation location;
        Tx tx;
        RecordLocation rc = null;
        Iterator iter = this.inflightTransactions.values().iterator();
        while (iter.hasNext()) {
            tx = (Tx)iter.next();
            location = tx.location;
            if (rc != null && rc.compareTo(location) >= 0) continue;
            rc = location;
        }
        iter = this.preparedTransactions.values().iterator();
        while (iter.hasNext()) {
            tx = (Tx)iter.next();
            location = tx.location;
            if (rc != null && rc.compareTo(location) >= 0) continue;
            rc = location;
        }
        return rc;
    }

    public boolean isDoingRecover() {
        return this.doingRecover;
    }

    public static class Tx {
        private final RecordLocation location;
        private ArrayList operations = new ArrayList();

        public Tx(RecordLocation location) {
            this.location = location;
        }

        public void add(RapidMessageStore store, Message msg, RecordLocation loc) {
            this.operations.add(new TxOperation(0, store, msg, loc));
        }

        public void add(RapidMessageStore store, MessageAck ack, RecordLocation loc) {
            this.operations.add(new TxOperation(1, store, ack, loc));
        }

        public void add(RapidTopicMessageStore store, JournalTopicAck ack, RecordLocation loc) {
            this.operations.add(new TxOperation(3, store, ack, loc));
        }

        public Message[] getMessages() {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                TxOperation op = (TxOperation)iter.next();
                if (op.operationType != 0) continue;
                list.add(op.data);
            }
            Message[] rc = new Message[list.size()];
            list.toArray(rc);
            return rc;
        }

        public MessageAck[] getAcks() {
            ArrayList<Object> list = new ArrayList<Object>();
            Iterator iter = this.operations.iterator();
            while (iter.hasNext()) {
                TxOperation op = (TxOperation)iter.next();
                if (op.operationType != 1) continue;
                list.add(op.data);
            }
            MessageAck[] rc = new MessageAck[list.size()];
            list.toArray(rc);
            return rc;
        }

        public ArrayList getOperations() {
            return this.operations;
        }
    }

    public static class TxOperation {
        static final byte ADD_OPERATION_TYPE = 0;
        static final byte REMOVE_OPERATION_TYPE = 1;
        static final byte ACK_OPERATION_TYPE = 3;
        public byte operationType;
        public RapidMessageStore store;
        public Object data;
        public RecordLocation location;

        public TxOperation(byte operationType, RapidMessageStore store, Object data, RecordLocation location) {
            this.operationType = operationType;
            this.store = store;
            this.data = data;
            this.location = location;
        }
    }
}

