/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.test;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.test.JmsSendReceiveTestSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JmsTopicSendReceiveWithTwoConnectionsTest
extends JmsSendReceiveTestSupport {
    protected static final Log log = LogFactory.getLog(JmsTopicSendReceiveWithTwoConnectionsTest.class);
    protected Connection sendConnection;
    protected Connection receiveConnection;
    protected Session receiveSession;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectionFactory = this.createConnectionFactory();
        log.info("Creating send connection");
        this.sendConnection = this.createSendConnection();
        log.info("Starting send connection");
        this.sendConnection.start();
        log.info("Creating receive connection");
        this.receiveConnection = this.createReceiveConnection();
        log.info("Starting receive connection");
        this.receiveConnection.start();
        log.info("Created sendConnection: " + this.sendConnection);
        log.info("Created receiveConnection: " + this.receiveConnection);
        this.session = this.sendConnection.createSession(false, 1);
        this.receiveSession = this.receiveConnection.createSession(false, 1);
        log.info("Created sendSession: " + this.session);
        log.info("Created receiveSession: " + this.receiveSession);
        this.producer = this.session.createProducer(null);
        this.producer.setDeliveryMode(this.deliveryMode);
        log.info("Created producer: " + this.producer + " delivery mode = " + (this.deliveryMode == 2 ? "PERSISTENT" : "NON_PERSISTENT"));
        if (this.topic) {
            this.consumerDestination = this.session.createTopic(this.getConsumerSubject());
            this.producerDestination = this.session.createTopic(this.getProducerSubject());
        } else {
            this.consumerDestination = this.session.createQueue(this.getConsumerSubject());
            this.producerDestination = this.session.createQueue(this.getProducerSubject());
        }
        log.info("Created  consumer destination: " + this.consumerDestination + " of type: " + this.consumerDestination.getClass());
        log.info("Created  producer destination: " + this.producerDestination + " of type: " + this.producerDestination.getClass());
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener(this);
        log.info("Started connections");
    }

    protected MessageConsumer createConsumer() throws JMSException {
        return this.receiveSession.createConsumer(this.consumerDestination);
    }

    protected void tearDown() throws Exception {
        this.session.close();
        this.receiveSession.close();
        this.sendConnection.close();
        this.receiveConnection.close();
    }

    protected Connection createReceiveConnection() throws Exception {
        return this.createConnection();
    }

    protected Connection createSendConnection() throws Exception {
        return this.createConnection();
    }

    protected ActiveMQConnectionFactory createConnectionFactory() throws Exception {
        return new ActiveMQConnectionFactory("vm://localhost?broker.persistent=false");
    }
}

