/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.tool;

import java.io.IOException;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.apache.activemq.tool.ToolSupport;

public class ConsumerTool
extends ToolSupport
implements MessageListener {
    protected int count = 0;
    protected int dumpCount = 10;
    protected boolean verbose = true;
    protected int maxiumMessages = 0;
    private boolean pauseBeforeShutdown;

    public static void main(String[] args) {
        ConsumerTool tool = new ConsumerTool();
        if (args.length > 0) {
            tool.url = args[0];
        }
        if (args.length > 1) {
            tool.topic = args[1].equalsIgnoreCase("true");
        }
        if (args.length > 2) {
            tool.subject = args[2];
        }
        if (args.length > 3) {
            tool.durable = args[3].equalsIgnoreCase("true");
        }
        if (args.length > 4) {
            tool.maxiumMessages = Integer.parseInt(args[4]);
        }
        tool.run();
    }

    public void run() {
        try {
            System.out.println("Connecting to URL: " + this.url);
            System.out.println("Consuming " + (this.topic ? "topic" : "queue") + ": " + this.subject);
            System.out.println("Using " + (this.durable ? "durable" : "non-durable") + " subscription");
            Connection connection = this.createConnection();
            Session session = this.createSession(connection);
            MessageConsumer consumer = null;
            consumer = this.durable && this.topic ? session.createDurableSubscriber((Topic)this.destination, this.consumerName) : session.createConsumer(this.destination);
            if (this.maxiumMessages <= 0) {
                consumer.setMessageListener(this);
            }
            connection.start();
            if (this.maxiumMessages > 0) {
                this.consumeMessagesAndClose(connection, session, consumer);
            }
        }
        catch (Exception e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    public void onMessage(Message message) {
        try {
            if (message instanceof TextMessage) {
                TextMessage txtMsg = (TextMessage)message;
                if (this.verbose) {
                    String msg = txtMsg.getText();
                    if (msg.length() > 50) {
                        msg = msg.substring(0, 50) + "...";
                    }
                    System.out.println("Received: " + msg);
                }
            } else if (this.verbose) {
                System.out.println("Received: " + message);
            }
        }
        catch (JMSException e) {
            System.out.println("Caught: " + e);
            e.printStackTrace();
        }
    }

    protected void consumeMessagesAndClose(Connection connection, Session session, MessageConsumer consumer) throws JMSException, IOException {
        System.out.println("We are about to wait until we consume: " + this.maxiumMessages + " message(s) then we will shutdown");
        for (int i = 0; i < this.maxiumMessages; ++i) {
            Message message = consumer.receive();
            this.onMessage(message);
        }
        System.out.println("Closing connection");
        consumer.close();
        session.close();
        connection.close();
        if (this.pauseBeforeShutdown) {
            System.out.println("Press return to shut down");
            System.in.read();
        }
    }
}

