/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import java.io.IOException;
import java.net.URI;
import junit.framework.TestCase;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BadConnectionTest
extends TestCase {
    protected static final Log log = LogFactory.getLog(BadConnectionTest.class);
    protected Transport transport;

    public void testConnectingToUnavailableServer() throws Exception {
        try {
            this.transport.asyncRequest(new ActiveMQMessage(), null);
            BadConnectionTest.fail((String)"This should never succeed");
        }
        catch (IOException e) {
            log.info("Caught expected exception: " + e, e);
        }
    }

    protected Transport createTransport() throws Exception {
        return TransportFactory.connect(new URI("failover://(tcp://doesNotExist:1234)?useExponentialBackOff=false&maxReconnectAttempts=3&initialReconnectDelay=100"));
    }

    protected void setUp() throws Exception {
        this.transport = this.createTransport();
        this.transport.setTransportListener(new TransportListener(){

            public void onCommand(Object command) {
            }

            public void onException(IOException error) {
            }

            public void transportInterupted() {
            }

            public void transportResumed() {
            }
        });
        this.transport.start();
    }

    protected void tearDown() throws Exception {
        if (this.transport != null) {
            this.transport.stop();
        }
    }
}

