/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.failover;

import edu.emory.mathcs.backport.java.util.concurrent.CountDownLatch;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.TransportConnector;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.transport.TransportListener;
import org.apache.activemq.transport.mock.MockTransport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReconnectTest
extends TestCase {
    protected static final Log log = LogFactory.getLog(ReconnectTest.class);
    public static final int MESSAGES_PER_ITTERATION = 10;
    public static final int WORKER_COUNT = 10;
    private BrokerService bs;
    private URI tcpUri;
    private AtomicInteger interruptedCount = new AtomicInteger();
    private Worker[] workers;
    static /* synthetic */ Class class$org$apache$activemq$transport$mock$MockTransport;

    public void testReconnects() throws Exception {
        for (int k = 1; k < 5; ++k) {
            int i;
            System.out.println("Test run: " + k);
            for (i = 0; i < 10; ++i) {
                for (int j = 0; this.workers[i].iterations.get() == 0 && j < 5; ++j) {
                    this.workers[i].assertNoErrors();
                    System.out.println("Waiting for worker " + i + " to finish an iteration.");
                    Thread.sleep(1000L);
                }
                ReconnectTest.assertTrue((String)("Worker " + i + " never completed an interation."), (this.workers[i].iterations.get() != 0 ? 1 : 0) != 0);
                this.workers[i].assertNoErrors();
            }
            System.out.println("Simulating transport error to cause reconnect.");
            for (i = 0; i < 10; ++i) {
                this.workers[i].failConnection();
            }
            while (this.interruptedCount.get() < 10) {
                System.out.println("Waiting for connections to get interrupted.. at: " + this.interruptedCount.get());
                Thread.sleep(1000L);
            }
            System.out.println("Pausing before starting next iterations...");
            Thread.sleep(1000L);
            this.interruptedCount.set(0);
            for (i = 0; i < 10; ++i) {
                this.workers[i].iterations.set(0);
            }
        }
    }

    protected void setUp() throws Exception {
        this.bs = new BrokerService();
        this.bs.setPersistent(false);
        this.bs.setUseJmx(true);
        TransportConnector connector = this.bs.addConnector("tcp://localhost:0");
        this.bs.start();
        this.tcpUri = connector.getConnectUri();
        this.workers = new Worker[10];
        for (int i = 0; i < 10; ++i) {
            this.workers[i] = new Worker();
            this.workers[i].start();
        }
    }

    protected void tearDown() throws Exception {
        for (int i = 0; i < 10; ++i) {
            this.workers[i].stop();
        }
        new ServiceStopper().stop(this.bs);
    }

    class Worker
    implements Runnable,
    ExceptionListener {
        private ActiveMQConnection connection;
        private AtomicBoolean stop = new AtomicBoolean(false);
        public AtomicInteger iterations = new AtomicInteger();
        public CountDownLatch stopped = new CountDownLatch(1);
        private Throwable error;

        public Worker() throws URISyntaxException, JMSException {
            URI uri = new URI("failover://(mock://(" + ReconnectTest.this.tcpUri + "))");
            ActiveMQConnectionFactory factory = new ActiveMQConnectionFactory(uri);
            this.connection = (ActiveMQConnection)factory.createConnection();
            this.connection.setExceptionListener(this);
            this.connection.addTransportListener(new TransportListener(){

                public void onCommand(Object command) {
                }

                public void onException(IOException error) {
                    Worker.this.setError(error);
                }

                public void transportInterupted() {
                    ReconnectTest.this.interruptedCount.incrementAndGet();
                }

                public void transportResumed() {
                }
            });
            this.connection.start();
        }

        public void failConnection() {
            MockTransport mockTransport = (MockTransport)this.connection.getTransportChannel().narrow(class$org$apache$activemq$transport$mock$MockTransport == null ? (class$org$apache$activemq$transport$mock$MockTransport = ReconnectTest.class$("org.apache.activemq.transport.mock.MockTransport")) : class$org$apache$activemq$transport$mock$MockTransport);
            mockTransport.onException(new IOException("Simulated error"));
        }

        public void start() {
            new Thread(this).start();
        }

        public void stop() {
            this.stop.set(true);
            try {
                if (!this.stopped.await(5L, TimeUnit.SECONDS)) {
                    this.connection.close();
                    this.stopped.await();
                } else {
                    this.connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                ActiveMQQueue queue = new ActiveMQQueue("FOO");
                Session session = this.connection.createSession(false, 1);
                MessageConsumer consumer = session.createConsumer(queue);
                MessageProducer producer = session.createProducer(queue);
                producer.setDeliveryMode(2);
                while (!this.stop.get()) {
                    int i;
                    for (i = 0; i < 10; ++i) {
                        producer.send(session.createTextMessage("TEST:" + i));
                    }
                    for (i = 0; i < 10; ++i) {
                        consumer.receive();
                    }
                    this.iterations.incrementAndGet();
                }
                session.close();
            }
            catch (JMSException e) {
                this.setError(e);
            }
            finally {
                this.stopped.countDown();
            }
        }

        public void onException(JMSException error) {
            this.setError(error);
            this.stop();
        }

        public synchronized Throwable getError() {
            return this.error;
        }

        public synchronized void setError(Throwable error) {
            this.error = error;
        }

        public synchronized void assertNoErrors() {
            if (this.error != null) {
                this.error.printStackTrace();
                Assert.fail((String)("Got Exception: " + this.error));
            }
        }
    }
}

