/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.fanout;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.ResponseCorrelator;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.TransportFactory;
import org.apache.activemq.transport.TransportServer;
import org.apache.activemq.transport.discovery.DiscoveryAgent;
import org.apache.activemq.transport.discovery.DiscoveryAgentFactory;
import org.apache.activemq.transport.discovery.DiscoveryTransport;
import org.apache.activemq.transport.fanout.FanoutTransport;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.URISupport;

public class FanoutTransportFactory
extends TransportFactory {
    public Transport doConnect(URI location) throws IOException {
        try {
            Transport transport = this.createTransport(location);
            transport = new MutexTransport(transport);
            transport = new ResponseCorrelator(transport);
            return transport;
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport doCompositeConnect(URI location) throws IOException {
        try {
            return this.createTransport(location);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid location: " + location);
        }
    }

    public Transport createTransport(URI location) throws IOException, URISyntaxException {
        URISupport.CompositeData compositData = URISupport.parseComposite(location);
        HashMap parameters = new HashMap(compositData.getParameters());
        DiscoveryTransport transport = new DiscoveryTransport(this.createTransport(parameters));
        DiscoveryAgent discoveryAgent = DiscoveryAgentFactory.createDiscoveryAgent(compositData.getComponents()[0]);
        transport.setDiscoveryAgent(discoveryAgent);
        return transport;
    }

    public FanoutTransport createTransport(Map parameters) throws IOException {
        FanoutTransport transport = new FanoutTransport();
        IntrospectionSupport.setProperties(transport, parameters);
        return transport;
    }

    public TransportServer doBind(String brokerId, URI location) throws IOException {
        throw new IOException("Invalid server URI: " + location);
    }
}

