/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.reliable;

import java.net.SocketAddress;
import java.net.URI;
import org.apache.activemq.openwire.OpenWireFormat;
import org.apache.activemq.transport.CommandJoiner;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.reliable.DefaultReplayStrategy;
import org.apache.activemq.transport.reliable.DropCommandStrategy;
import org.apache.activemq.transport.reliable.ReliableTransport;
import org.apache.activemq.transport.reliable.ReplayStrategy;
import org.apache.activemq.transport.reliable.Replayer;
import org.apache.activemq.transport.reliable.UnreliableUdpTransport;
import org.apache.activemq.transport.udp.ResponseRedirectInterceptor;
import org.apache.activemq.transport.udp.UdpTransport;
import org.apache.activemq.transport.udp.UdpTransportTest;

public class UnreliableUdpTransportTest
extends UdpTransportTest {
    protected DropCommandStrategy dropStrategy = new DropCommandStrategy(){

        public boolean shouldDropCommand(int commandId, SocketAddress address, boolean redelivery) {
            if (redelivery) {
                return false;
            }
            return commandId % 3 == 2;
        }
    };

    protected Transport createProducer() throws Exception {
        log.info("Producer using URI: " + this.producerURI);
        OpenWireFormat wireFormat = this.createWireFormat();
        UnreliableUdpTransport transport = new UnreliableUdpTransport(wireFormat, new URI(this.producerURI));
        transport.setDropCommandStrategy(this.dropStrategy);
        ReliableTransport reliableTransport = new ReliableTransport((Transport)transport, transport);
        Replayer replayer = reliableTransport.getReplayer();
        reliableTransport.setReplayStrategy(this.createReplayStrategy(replayer));
        return new CommandJoiner(reliableTransport, wireFormat);
    }

    protected Transport createConsumer() throws Exception {
        log.info("Consumer on port: " + this.consumerPort);
        OpenWireFormat wireFormat = this.createWireFormat();
        UdpTransport transport = new UdpTransport(wireFormat, this.consumerPort);
        ReliableTransport reliableTransport = new ReliableTransport((Transport)transport, transport);
        Replayer replayer = reliableTransport.getReplayer();
        reliableTransport.setReplayStrategy(this.createReplayStrategy(replayer));
        ResponseRedirectInterceptor redirectInterceptor = new ResponseRedirectInterceptor(reliableTransport, transport);
        return new CommandJoiner(redirectInterceptor, wireFormat);
    }

    protected ReplayStrategy createReplayStrategy(Replayer replayer) {
        UnreliableUdpTransportTest.assertNotNull((String)"Should have a replayer!", (Object)replayer);
        return new DefaultReplayStrategy(1);
    }
}

